 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Mobile Subscriber (BSC)
 *
 *  AUTHOR: Dan Liu
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/


 #include "BSC.h"
 #include "message.h"       // InternalMessage ....


//bool bDebug = true;//true: print debug info; false: no print debug info;

/*
void debug( std::string &text )
{
  cout << "[debug_info]: " << text << endl;
  return;
}
*/


 BSC::BSC( const std::string &name ) : Atomic( name )
 , ReqInput(this-> addInputPort( "ReqInput"))
 , AckInput(this -> addInputPort( "AckInput"))
 , ReqOutput (this -> addOutputPort("ReqOutput"))
 , AckOutput (this -> addOutputPort("AckOutput"))
 , ProcessTime (00,00,00,20)
 //, ProcessTime2 (00,00,00,10)
 {
 }

 Model &BSC::initFunction()
  {
	cout << "BSC initFunction()" << endl;

    state = IDLE;// IDLE, UPDATE
    //ucmUpdateResult = UPDATE_DEFAULT;//DEFAULT, SUCC, FAIL
    //imIMSI = 123456;
	holdIn(Atomic::active, 0);//activate model
	//
    /*
	packetNumber = 0;
	state = idle;
	lastSentPacketAcked = 0;
	permissionToSend = 0;
	holdIn(Atomic::active, 0);
	*/
	return *this ;
  }

 /*********************************************************/
 Model &BSC::externalFunction( const ExternalMessage &msg )
  {
	cout << "BSC externalFunction() at " << msg.time() << ", value: " << msg.value() << endl;

	switch( state )
	{
	  case IDLE:
        if ( ( ReqInput == msg.port() ) && ( UPDATE_REQ == msg.value() ) )
        {
          cout << "		I received UPDATE_REQ ext message " << msg.value() << "   at " << msg.time() << endl;
          state = UPDATE;
          holdIn(Atomic::active, Time(00,00,00,10));
          //call outputfunction() and internalfunction()
          //send update request;
        }

		break;
	  case UPDATE:
		break;
	  case ACK:
        if ( ( AckInput == msg.port() ) && ( UPDATE_ACK == msg.value() ) )
        {
        	cout << "		I received UPDATE_ACK ext message " << msg.value() << "   at " << msg.time() << endl;
        	//ucmUpdateResult = UPDATE_SUCC;
            //call outputfunction() and internalfunction()
        	//one complete procedure finished
        	//state = IDLE;
        	holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
        }
		break;
	  default:
		break;

	}

	return *this;
  }

 /*********************************************************/
 Model &BSC::internalFunction( const InternalMessage & )
 {
	cout << "BSC internalFunction()" << endl;

	if ( 0 == state ) cout << "		The input state is IDLE" << endl;
	if ( 1 == state ) cout << "		The input state is UPDATE" << endl;
	if ( 2 == state ) cout << "		The input state is ACK" << endl;

	switch ( state )
	{
	  case IDLE:
        //sigma ta(PASSIVE)//periodical update request(30min) set
		//ucmUpdateResult = UPDATE_DEFAULT;//reset variables
		cout << "		Call passivate()" << endl;
		passivate();// waiting for input message
		break;
	  case UPDATE:
        //sigma ta(UPDATE)//time out(10s) set
		//holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
		state = ACK;
	    cout << "		Call passivate()" << endl;
	    passivate();// waiting for input message
		break;
	  case ACK:
        //sigma ta(UPDATE)//time out(10s) set
		state = IDLE;
		//holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
		break;
	  default:

		break;

	}


	if ( 0 == state ) cout << "		The Output state is IDLE" << endl;
	if ( 1 == state ) cout << "		The Output state is UPDATE" << endl;
	if ( 2 == state ) cout << "		The Output state is ACK" << endl;

    return *this;
 }

 /*********************************************************/
 Model &BSC::outputFunction( const InternalMessage &msg )
 {
	 cout << "BSC outputFunction() at " << msg.time() << endl;

	 switch ( state )
	 {
	   case IDLE:
         // no output;
		 break;
	   case UPDATE:
         sendOutput( msg.time(), ReqOutput, UPDATE_REQ );//send update request
		 cout << "		I sent update request at " << msg.time() << endl;
		 break;
	   case ACK:
         sendOutput( msg.time(), AckOutput, UPDATE_ACK );//send update ack
		 cout << "		I sent update ack at " << msg.time() << endl;
		 break;
	   default:
		 break;

	 }

	return *this ;
 }

 /*********************************************************/
 BSC::~BSC()
 {
 }

