 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Mobile Subscriber (MSC)
 *
 *  AUTHOR: Dan Liu
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/


 #include "MSC.h"
 #include "message.h"       // InternalMessage ....


bool bDebug = true;//true: print debug info; false: no print debug info;

bool bSameMSC = false;

/*
void debug( std::string &text )
{
  cout << "[debug_info]: " << text << endl;
  return;
}
*/


 MSC::MSC( const std::string &name ) : Atomic( name )
 , UpdateReqIn(this-> addInputPort( "UpdateReqIn"))
 , HRAckIn(this -> addInputPort( "HRAckIn"))
 , HRReqOut (this -> addOutputPort("HRReqOut"))
 , UpdateAckOut (this -> addOutputPort("UpdateAckOut"))
 , ProcessTime (00,00,00,20)
 //, ProcessTime2 (00,00,00,10)
 {
 }

 Model &MSC::initFunction()
  {
	cout << "MSC initFunction()" << endl;

    state = IDLE;// IDLE, UPDATE
    //ucmUpdateResult = UPDATE_DEFAULT;//DEFAULT, SUCC, FAIL
    //imIMSI = 123456;
    memset( camIMSI, 0, 100 );
	holdIn(Atomic::active, 0);//activate model
	//
    /*
	packetNumber = 0;
	state = idle;
	lastSentPacketAcked = 0;
	permissionToSend = 0;
	holdIn(Atomic::active, 0);
	*/
	return *this ;
  }

 /*********************************************************/
 Model &MSC::externalFunction( const ExternalMessage &msg )
  {
	cout << "MSC externalFunction() at " << msg.time() << ", value: " << msg.value() << endl;

	switch( state )
	{
	  case IDLE:
        if ( ( UpdateReqIn == msg.port() ) && ( UPDATE_REQ == msg.value() ) )
        {
          cout << "		I received UPDATE_REQ ext message " << msg.value() << "   at " << msg.time() << endl;
          if ( bSameMSC )
          {
            //update new Location Area in MSC
            state = UPDATE;
            //call update procedure
            holdIn(Atomic::active, Time(00,00,00,10));

          }
          //new imsi
          else
          {
            //request to HR
        	state = REQ_HR;
        	// call outputfunction() and internalfunction()
            holdIn(Atomic::active, 0);
          }

        }

		break;
	  case UPDATE:
		break;
	  case REQ_HR:
        if ( ( HRAckIn == msg.port() ) && ( HR_ACK == msg.value() ) )
        {
        	cout << "		I received HR_ACK ext message " << msg.value() << "   at " << msg.time() << endl;
        	//ucmUpdateResult = UPDATE_SUCC;
            //call procedure of adding new imsi
        	state = ACK_UPDATE;
        	holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
        }
		break;
	  default:
		break;

	}

	return *this;
  }

 /*********************************************************/
 Model &MSC::internalFunction( const InternalMessage & )
 {
	cout << "MSC internalFunction()" << endl;

	if ( 0 == state ) cout << "		The input state is IDLE" << endl;
	if ( 1 == state ) cout << "		The input state is UPDATE" << endl;
	if ( 2 == state ) cout << "		The input state is ACK_UPDATE" << endl;
	if ( 3 == state ) cout << "		The input state is REQ_HR" << endl;

	switch ( state )
	{
	  case IDLE:
        //sigma ta(PASSIVE)//periodical update request(30min) set
		//ucmUpdateResult = UPDATE_DEFAULT;//reset variables
		cout << "		Call passivate()" << endl;
		passivate();// waiting for input message
		break;
	  case UPDATE:
        //sigma ta(UPDATE)//time out(10s) set
		//update location area procedure
		state = ACK_UPDATE;
		holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
		break;
	  case ACK_UPDATE:
        //sigma ta(UPDATE)//time out(10s) set
		state = IDLE;
		//holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
		break;
	  case REQ_HR:
        //sigma ta(UPDATE)//time out(10s) set
		//wait for ack message

			cout << "		Call passivate()" << endl;
			passivate();// waiting for input message
		break;
	  default:

		break;

	}


	if ( 0 == state ) cout << "		The Output state is IDLE" << endl;
	if ( 1 == state ) cout << "		The Output state is UPDATE" << endl;
	if ( 2 == state ) cout << "		The Output state is ACK_UPDATE" << endl;
	if ( 3 == state ) cout << "		The Output state is REQ_HR" << endl;

    return *this;
 }

 /*********************************************************/
 Model &MSC::outputFunction( const InternalMessage &msg )
 {
	 cout << "MSC outputFunction() at " << msg.time() << endl;

	 switch ( state )
	 {
	   case IDLE:
         // no output;
		 break;
	   case REQ_HR:
         sendOutput( msg.time(), HRReqOut, HR_REQ );//send update request
		 cout << "		I sent HR request at " << msg.time() << endl;
		 break;
	   case ACK_UPDATE:
         sendOutput( msg.time(), UpdateAckOut, UPDATE_ACK );//send update ack
		 cout << "		I sent update ack at " << msg.time() << endl;
		 break;
	   default:
		 break;

	 }

	return *this ;
 }

 /*********************************************************/
 MSC::~MSC()
 {
 }

