 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Mobile Subscriber (MS)
 *
 *  AUTHOR: Dan Liu
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/


 #include "MS.h"
 #include "message.h"       // InternalMessage ....


//bool bDebug = true;//true: print debug info; false: no print debug info;

/*
void debug( std::string &text )
{
  cout << "[debug_info]: " << text << endl;
  return;
}
*/


 MS::MS( const std::string &name ) : Atomic( name )
 , In(addInputPort( "In" ))
 , Out(addOutputPort( "Out" ))
 , ProcessTime (00,00,00,20)
 //, ProcessTime2 (00,00,00,10)
 {
 }

 Model &MS::initFunction()
  {
	cout << "MS initFunction()" << endl;

    state = IDLE;// IDLE, UPDATE
    ucmUpdateResult = UPDATE_DEFAULT;//DEFAULT, SUCC, FAIL
    imIMSI = 123456;
	holdIn(Atomic::active, 0);//activate model
	//
    /*
	packetNumber = 0;
	state = idle;
	lastSentPacketAcked = 0;
	permissionToSend = 0;
	holdIn(Atomic::active, 0);
	*/
	return *this ;
  }

 /*********************************************************/
 Model &MS::externalFunction( const ExternalMessage &msg )
  {
	cout << "MS externalFunction() at " << msg.time() << ", value: " << msg.value() << endl;

	switch( state )
	{
	  case IDLE:
        if ( ( In == msg.port() ) && ( FORCE_UPDATE == msg.value() ) )
        {
          cout << "		I received FORCE_UPDATE ext message " << msg.value() << "   at " << msg.time() << endl;
          state = UPDATE;
          holdIn(Atomic::active, Time(00,00,00,10));
          //call outputfunction() and internalfunction()
          //send update request;
        }

		break;
	  case UPDATE:
        if ( ( In == msg.port() ) && ( UPDATE_ACK == msg.value() ) )
        {
        	cout << "		I received FORCE_UPDATE_ACK ext message " << msg.value() << "   at " << msg.time() << endl;
        	ucmUpdateResult = UPDATE_SUCC;
            //call outputfunction() and internalfunction()
        	//one complete procedure finished
        	state = IDLE;
        	holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
        }
		break;
	  default:
		break;

	}

    /*
	if (msg.port() == In ){
		cout << "		I received ACK for packet " << msg.value() << "   at " << msg.time() << endl;
		ackValue = msg.value();
		state = rcvAck;
		lastSentPacketAcked = 1;
		holdIn(Atomic::active, Time(00,00,00,10));
	}
	*/

	return *this;
  }

 /*********************************************************/
 Model &MS::internalFunction( const InternalMessage & )
 {
	cout << "MS internalFunction()" << endl;
	/*
	if (state == 0 ) cout << "		The input state is idle" << endl;
	if (state == 1 ) cout << "		The input state is sendPack" << endl;
	if (state == 2 ) cout << "		The input state is rcvAck" << endl;
	*/
	if ( 0 == state ) cout << "		The input state is IDLE" << endl;
	if ( 1 == state ) cout << "		The input state is UPDATE" << endl;

	switch ( state )
	{
	  case IDLE:
        //sigma ta(PASSIVE)//periodical update request(30min) set
		ucmUpdateResult = UPDATE_DEFAULT;//reset variables
		cout << "		Call passivate()" << endl;
		passivate();// waiting for input message
		break;
	  case UPDATE:
        //sigma ta(UPDATE)//time out(10s) set
		//holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
	    cout << "		Call passivate()" << endl;
	    passivate();// waiting for input message
		break;
	  default:

		break;

	}


	if ( 0 == state ) cout << "		The Output state is IDLE" << endl;
	if ( 1 == state ) cout << "		The Output state is UPDATE" << endl;

	/*
	switch (state){
				    case idle:
								    if (packetNumber == 0){
                                       state = sendPack;
                                    }
                                     else {
                                    	  cout << "		Call passivate()" << endl;
                                          passivate();
                                     }
									break;
				    case sendPack:
									if (packetNumber > 9){
										state = idle;
									}else {
										if (lastSentPacketAcked == 1 || packetNumber == 0){
											packetNumber ++;
											permissionToSend = 1;
											cout << "		packetNumber " << packetNumber << endl;
											holdIn(Atomic::active, ProcessTime);
										}else {
											state = idle;
										}
									}
									break;
				    case rcvAck:
									state = sendPack;
									permissionToSend = 0;
									break;
        		  }

	if (state == 0 ) cout << "		The Output state is idle" << endl;
	if (state == 1 ) cout << "		The Output state is sendPack" << endl;
	if (state == 2 ) cout << "		The Output state is rcvAck" << endl;
	*/
    return *this;
 }

 /*********************************************************/
 Model &MS::outputFunction( const InternalMessage &msg )
 {
	 cout << "MS outputFunction() at " << msg.time() << endl;

	 switch ( state )
	 {
	   case IDLE:
         // no output;
		 break;
	   case UPDATE:
         sendOutput( msg.time(), Out, UPDATE_REQ );//send update request
		 cout << "		I sent update request with imsi " << imIMSI << "   at " << msg.time() << endl;
		 break;
	   default:
		 break;

	 }

	 //
	 /*
	 if (state == sendPack && packetNumber > 0 && permissionToSend == 1){
		 sendOutput( msg.time(), Out, packetNumber) ;
		 lastSentPacketAcked = 0;
		 cout << "		I sent packet number " << packetNumber << "   at " << msg.time() << endl;
	 }
	 if (state == rcvAck){
			 cout << "		I finished processing of received ACK for packet number " << ackValue << "   at " << msg.time() << endl;
	 }
	 */

	return *this ;
 }

 /*********************************************************/
 MS::~MS()
 {
 }

