 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Mobile Subscriber (HR)
 *
 *  AUTHOR: Dan Liu
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/


 #include "HR.h"
 #include "message.h"       // InternalMessage ....


//bool bDebug = true;//true: print debug info; false: no print debug info;

bool bSameHR = false;

/*
void debug( std::string &text )
{
  cout << "[debug_info]: " << text << endl;
  return;
}
*/


 HR::HR( const std::string &name ) : Atomic( name )
 , In(this-> addInputPort( "In"))
 , Out (this -> addOutputPort("Out"))
 , ProcessTime (00,00,00,20)
 //, ProcessTime2 (00,00,00,10)
 {
 }

 Model &HR::initFunction()
  {
	cout << "HR initFunction()" << endl;

    state = IDLE;// IDLE, UPDATE
    //ucmUpdateResult = UPDATE_DEFAULT;//DEFAULT, SUCC, FAIL
    //imIMSI = 123456;
	holdIn(Atomic::active, 0);//activate model
	//
    /*
	packetNumber = 0;
	state = idle;
	lastSentPacketAcked = 0;
	permissionToSend = 0;
	holdIn(Atomic::active, 0);
	*/
	return *this ;
  }

 /*********************************************************/
 Model &HR::externalFunction( const ExternalMessage &msg )
  {
	cout << "HR externalFunction() at " << msg.time() << ", value: " << msg.value() << endl;

	switch( state )
	{
	  case IDLE:
        if ( ( In == msg.port() ) && ( HR_REQ == msg.value() ) )
        {
          cout << "		I received HR_REQ ext message " << msg.value() << "   at " << msg.time() << endl;
          state = UPDATE;
          holdIn(Atomic::active, Time(00,00,00,10));

        }

		break;
	  case UPDATE:
		break;
	  default:
		break;

	}

	return *this;
  }

 /*********************************************************/
 Model &HR::internalFunction( const InternalMessage & )
 {
	cout << "HR internalFunction()" << endl;

	if ( 0 == state ) cout << "		The input state is IDLE" << endl;
	if ( 1 == state ) cout << "		The input state is UPDATE" << endl;
	if ( 2 == state ) cout << "		The input state is ACK_UPDATE" << endl;
	if ( 3 == state ) cout << "		The input state is REQ_HR" << endl;

	switch ( state )
	{
	  case IDLE:
        //sigma ta(PASSIVE)//periodical update request(30min) set
		//ucmUpdateResult = UPDATE_DEFAULT;//reset variables
		cout << "		Call passivate()" << endl;
		passivate();// waiting for input message
		break;
	  case UPDATE:
        //sigma ta(UPDATE)//time out(10s) set
		//update location area procedure
		state = ACK_UPDATE;
		holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
		break;
	  case ACK_UPDATE:
        //sigma ta(UPDATE)//time out(10s) set
		state = IDLE;
		//holdIn(Atomic::active, Time(00,00,00,10));//delay 10ms
		break;
	  default:

		break;

	}


	if ( 0 == state ) cout << "		The Output state is IDLE" << endl;
	if ( 1 == state ) cout << "		The Output state is UPDATE" << endl;
	if ( 2 == state ) cout << "		The Output state is ACK_UPDATE" << endl;
	if ( 3 == state ) cout << "		The Output state is REQ_HR" << endl;

    return *this;
 }

 /*********************************************************/
 Model &HR::outputFunction( const InternalMessage &msg )
 {
	 cout << "HR outputFunction() at " << msg.time() << endl;

	 switch ( state )
	 {
	   case IDLE:
         // no output;
		 break;
	   case ACK_UPDATE:
         sendOutput( msg.time(), Out, HR_ACK );//send update ack
		 cout << "		I sent update ack at " << msg.time() << endl;
		 break;
	   default:
		 break;

	 }

	return *this ;
 }

 /*********************************************************/
 HR::~HR()
 {
 }

