 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Mobile Subscriber (HR)
 *
 *  AUTHOR: Dan Liu
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __HR_H
 #define __HR_H

 #include "atomic.h"   // class Atomic
 #include "string.h"	  // class String


#define UPDATE_DEFAULT 0
#define UPDATE_SUCC    1
#define UPDATE_FAIL    2

//define -100 - -1 as instructions contained in message
#define FAIL             -1
#define FORCE_UPDATE     -2
#define FORCE_UPDATE_ACK -3
#define UPDATE_REQ       -4
#define UPDATE_ACK       -5
#define HR_REQ           -6
#define HR_ACK           -7


 class HR : public Atomic
 {
   public:
	       HR ( const std::string &name = "HR" );  //Default constructor
	       virtual std::string className() const {  return "HR" ;}
	       ~HR();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        /*
	        const Port &In;
	        Port &Out;
	        */

	          const Port &In;
	          Port &Out;

	        Time ProcessTime;


            //unsigned char ucmUpdateResult;//
            //int imIMSI;//

            enum State
            {
              IDLE,
              UPDATE,
              ACK_UPDATE,
            };
            State state;

	        /*
         	int packetNumber;
         	int ackValue;
         	int lastSentPacketAcked;
         	int permissionToSend;
         	enum State{
			            idle,
			            sendPack,
			            rcvAck,
		              };
		    State state;
		    */

 };

#endif   //__HR_H
