 /***********************************************
 *
 *  DESCRIPTION: Atomic Model Mobile Subscriber (BTS)
 *
 *  AUTHOR: Dan Liu
 *
 *  DATE: 20/10/2014
 *
 ***********************************************/

 #ifndef __BTS_H
 #define __BTS_H

 #include "atomic.h"   // class Atomic
 #include "string.h"	  // class String


#define UPDATE_DEFAULT 0
#define UPDATE_SUCC    1
#define UPDATE_FAIL    2

//define -100 - -1 as instructions contained in message
#define FAIL             -1
#define FORCE_UPDATE     -2
#define FORCE_UPDATE_ACK -3
#define UPDATE_REQ       -4
#define UPDATE_ACK       -5


 class BTS : public Atomic
 {
   public:
	       BTS ( const std::string &name = "BTS" );  //Default constructor
	       virtual std::string className() const {  return "BTS" ;}
	       ~BTS();

   protected:
	          Model &initFunction();
	          Model &externalFunction( const ExternalMessage & );
	          Model &internalFunction( const InternalMessage & );
	          Model &outputFunction( const InternalMessage & );

   private:
	        /*
	        const Port &In;
	        Port &Out;
	        */

	          const Port &ReqInput;
	          const Port &AckInput;
	          Port &ReqOutput;
	          Port &AckOutput;

	        Time ProcessTime;

            //unsigned char ucmUpdateResult;//
            //int imIMSI;//

            enum State
            {
              IDLE,
              UPDATE,
              ACK,
            };
            State state;

	        /*
         	int packetNumber;
         	int ackValue;
         	int lastSentPacketAcked;
         	int permissionToSend;
         	enum State{
			            idle,
			            sendPack,
			            rcvAck,
		              };
		    State state;
		    */

 };

#endif   //__BTS_H
