/*******************************************************************
*  DESCRIPTION: Atomic Model Sort
*  AUTHOR: Emad Khan
*  EMAIL: emadkhan@cmail.carleton.ca
*  DATE: 30/10/2016
*******************************************************************/

#ifndef __PACK_H
#define __PACK_H

#include <list>
#include "atomic.h"     // class Atomic

class pack : public Atomic
{
public:
	pack( const string &name = "Packaging" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
   const Port &packorder ;
   Port &reqorder ;
	Time prepTime;
	Time timeLeft;

};	// class Pack

// ** inline ** //
inline
string pack::className() const
{
	return "pack" ;
}

#endif   //__Pack_H
