/*******************************************************************
*  DESCRIPTION: Atomic Model Admin
*  AUTHOR: Emad Khan
*  EMAIL: emadkhan@cmail.carleton.ca
*  DATE: 30/10/2016
*******************************************************************/
#ifndef __ADMIN_H
#define __ADMIN_H

#include <list>
#include "atomic.h"     // class Atomic

class admin : public Atomic
{
public:
	admin( const string &name = "Administration Office" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &newclt; //Input Port: New Client
	const Port &nxtclt; //Input Port: Next Client
	Port &order ; //Output Port: Order
	Time prepTime ; //Prepartion Time
	Time openHrs ; //Opening Time
	Time closeHrs ; //Closing Time
	unsigned int numberofSeats ; //Integer: Number of Seats in queue
	string initInt ; //String to Int
	bool full_space ; //Boolean: If queue is full
	bool clt_is_ready ; //Boolean: If Client is ready
	typedef list<Value> ElementList ;
	ElementList elements ;

	Time timeLeft;

};	// class Admin

// ** inline ** //
inline
string admin::className() const
{
	return "admin" ;
}

#endif   //__ADMIN_H
