#ifdef GL_ES
precision mediump float;
precision mediump int;
#endif

#define PROCESSING_TEXTURE_SHADER

//#version 450

uniform sampler2D texture;
uniform float pressures[1000];
uniform int COLOR_ID_STEP;
uniform int MODE;
uniform int CROWDCOUNT;

varying vec4 vertColor;
varying vec4 vertTexCoord;

int color_to_id(vec4 clr){
	clr = clr * 255;
	int r = int(clr.x) << 16;
	int g = int(clr.y) << 8;
	int b = int(clr.z);
	int id = r+g+b - 0xA;
	return id / COLOR_ID_STEP;
}

void main() {
  // Input crowd color
  vec4 col = texture2D(texture, vertTexCoord.st);
  if( ( col.x==0&&col.y==0&&col.z<(10.0/255) ) || (col.x>0.9&&col.y>0.9&&col.z>0.9)) 
    // obstacle or environment: color pass through.
  	gl_FragColor = col;
  else{ 	
    // entity: shade it.
  	int entityID = color_to_id(col);
  	
    if(MODE==1) // pressure
       gl_FragColor = vec4(vec3(pressures[entityID]),1);
    if(MODE==2) // objective
      gl_FragColor = mix(col, ((entityID<floor(CROWDCOUNT*0.5)? vec4(0.7,0.1,0.3,1):vec4(0.1,0.1,0.8,1))), 0.5);
      // gl_FragColor = mix(col, ((entityID>floor(CROWDCOUNT*0.75))? vec4(0.7,0.1,0.3,1): // red 
      //                          (entityID>floor(CROWDCOUNT*0.50))? vec4(0.1,0.7,0.3,1): // green
      //                          (entityID>floor(CROWDCOUNT*0.25))? vec4(0.6,0.6,0.1,1): // yellow
      //                                                             vec4(0.1,0.1,0.8,1)), 0.75); // blue
  }   
}
