// File History:
//----------------
// For the SYSC5104 course in Fall 2017, supervised by Dr. Gabriel Wainer
// 
//Mods.pde:  This file includes the modifications by Shashi Bhushan
//      -Added functionality for flocking
//        -Three steering forces are calculated namely, CohesionForce, separationForce and AlignmnetForce
//        -All the three forces can be disabled and re-enabled in runtime by pressing relevant keys: Cntrl for cohesionForce, Shift for separationForce and Alt for alignmentForce
//      
//      * All the modifications for flocking can be searched by searcing the keyword "ModFlocking"
//_____________________________________________________________________________________
//For the SYSC5104 course in Fall 2016, supervised by Dr. Gabriel Wainer
//
// Mods.pde:  This file includes the modifications by Princy and Walter 
//            to model meeting, uncooperative and mouse-following behaviour.
//            Plus, added the ability to load obstacles from a PNG image
//            file.
//
//****************** Global Variables Section ************************//
//********************************************************************//
int[] specialIDs;                // A list of IDs of the modified entities
PVector[] initialPositions;      // A list of their initial positions 
PVector groupAvgPosition;        // Keeps track of the average of special entity positions
PVector mousePosition;           // Keeps track of mouse position
boolean meetingOccured;          // Becomes true if the special entities have met/gathered
PImage obstacleMap;              // Holds an image of the obstacle map
int obstacleChoice;              // Choice of multiple available obstacles
boolean recordTimeToMeeting;     // Enable printing of Time-To-Meeting (in seconds)

int WIDTH = 500, HEIGHT = 600;   // Canvas dimensions (1 pixel = 10cm in real life)
// Non-special entities initial distribution (see EntitySystem.initializePositions for options)
String NONSPECIAL_INIT_DISTRIBUTION = "bidirectional";
// Are they in bidirectional flow, or standing still
boolean NONSPECIAL_BIDIRECTIONAL = true;      
// Simulation starts paused?
boolean START_PAUSED = false;

//ModFlocking
int flockRadius = 50;
boolean cohesionFlag = true; // Flag to control the cohesion force On/Off
boolean separationFlag = true; // Flag to control the separation force On/Off
boolean alignmentFlag = true; // Flag to control the alignment force On/Off
PVector[] cohesionForcesArray;  // array to hold all cohesion forces
PVector[] separationForcesArray;  // array to hold all separation forces
PVector[] alignmentForcesArray;   // array to hold all alignment forces
float cohesionWeight = 0.5;  // Weight of cohesionForce. change in the force changes the strength of cohesion force
float separationWeight = 0.4;  //Weight of separationForce. change in the force changes the strength of cohesion force
float alignmentWeight = 0.5;  //Weight of alignmentForce. change in the force changes the strength of cohesion force
PVector horizontalEnd; // Holds the direction where the special entites should move
boolean[] specialIDsMeet; // Holds the status of special entities, whether they have reached the desired distance
int travelDistance = 420; // Integer that holds the distacne we want the special entities to travel
//****************** State Initialization Section ****************************//
// Specify special entity IDs, intitial positions, etc. Runs once on startup.
// This section is similar to CellDEVS inital value (.val) files.
//****************************************************************************//
void modification_Initialization(){
  // Specify the IDs of the special entities using an explicit list
  specialIDs = new int[]{0,1,2,3,4,5,6,7,8,9};
  
  //ModFlocking: Specicial entities(boids), have not reached the desired distance initially
  specialIDsMeet = new boolean[]{false,false,false,false,false,false,false,false,false,false };
  
  // Specify initial positions for each special entity
   // Using an explicit list
   initialPositions = new PVector[] { 
                                      //new PVector(250, height),
                                      //new PVector(width-250,0)
                                  
                                      //new PVector(95, 145),
                                      //new PVector(405, 455)
                                      
                                      //new PVector(width/2, 80),
                                      //new PVector(width/2, height-80)
                                    };

//    //Or procedurally in a loop
   initialPositions = new PVector[specialIDs.length]; // allocate empty array
   for(int i=0; i<specialIDs.length; i++){
     // ModFlocking : specific location cluster
     initialPositions[i] = new PVector(random(20,20), random(275,325));
   }
  
  // Apply the initialPositions array to the special entities
  for(int i=0; i<specialIDs.length; i++){
    crowd.getEntities()[specialIDs[i]].setPosition(initialPositions[i]);  
    crowd.getEntities()[specialIDs[i]].setInitialPosition(initialPositions[i]);
  }
  
  // Specify custom obstacle map 
  obstacleMap = loadImage("obstacle1.png");
  obstacleChoice = 0;  
  
  // Enable Time-To-Meeting Recording
  recordTimeToMeeting = true;
  
  //ModFlocking
  separationForcesArray = new PVector[specialIDs.length]; // initialize separation forces array
  cohesionForcesArray = new PVector[specialIDs.length]; // initialize cohesion forces array
  alignmentForcesArray = new PVector[specialIDs.length]; // initialize alignment forces array
  
}


//****************** Update Section **********************************//
// Compute the following once every frame. These are useful values. 
//   Whether they actually get used or not, that's up to the modeler, 
//   but they are computed every frame anyway, in case they are needed
//********************************************************************//
void modification_Update(){
  // Update mouse position
  mousePosition = new PVector (mouseX, mouseY, 0);
  
  //ModFlocking
  horizontalEnd = new PVector (500, 300, 0);
  
  // Compute the average position of special entities 
  groupAvgPosition = new PVector(0,0,0); // initialize empty vector
  for (int i=0; i<specialIDs.length; i++) {
    groupAvgPosition.add(crowd.getEntities()[specialIDs[i]].getPosition());
  }
  groupAvgPosition.div(specialIDs.length);  // Avg = sum.dividedBy(count);
  
  // Compute whether the special entities have met or not
  meetingOccured = false;        // assume not at first
  float left = width, right=0;   // bounding box of the group
  float top = height, bottom=0;
  //for (int i=0; i<specialIDs.length; i++) {
  //  PVector pos = crowd.getEntities()[specialIDs[i]].getPosition();
  //  if(pos.x < left  ) left   = pos.x;
  //  if(pos.x > right ) right  = pos.x;
  //  if(pos.y < top   ) top    = pos.y;
  //  if(pos.y > bottom) bottom = pos.y;
  //}
  //float boundingBoxWidth = right-left;
  //float boundingBoxHeight= bottom-top;
  //float closeEnoughDistance = specialIDs.length * CONE_RADIUS * 0.7;
  //float closeEnoughDistance_x = specialIDs.length * CONE_RADIUS * 0.7;
  //if( (boundingBoxWidth < closeEnoughDistance) && (boundingBoxHeight < closeEnoughDistance) ){
  //  if( (boundingBoxWidth >= 400) /*&& (boundingBoxHeight < closeEnoughDistance)*/ ){
  //  meetingOccured = true;  // If the bounding box of special entities is small enough, they've met! 
  //}
  
  //ModFlocking: Above code is commented out as meeting occured condition is changed for flocking. New logic is added for flocking
  //ModFlocking: To see when all the special entities (boids) cross the desired distance
  for (int i=0; i<specialIDs.length; i++) {
    PVector pos = crowd.getEntities()[specialIDs[i]].getPosition();
    if(pos.x >= travelDistance){
    specialIDsMeet[i] = true;
    }    
  }
  
  //ModFlocking: meetingOccured is true only if all the boids have reached or crossed the desired distance
  if(specialIDsMeet[0] == true && specialIDsMeet[1] == true && specialIDsMeet[2] == true && specialIDsMeet[3] == true && specialIDsMeet[4] == true &&
  specialIDsMeet[5] == true && specialIDsMeet[6] == true && specialIDsMeet[7] == true && specialIDsMeet[8] == true && specialIDsMeet[9] == true ){
     meetingOccured = true; 
  }
  
  // Print the Time-to-Meeting?
  if(recordTimeToMeeting && meetingOccured){
    // Time advance is 50ms of real time; So 1 second = 20 frames
    String elapsedTime = String.format("%.3f", frameCount/20.0); // to 3 decimal places
    println("Time-to-meeting = " + elapsedTime + " seconds");
    recordTimeToMeeting = false; // done recording it, don't want to run this again
  }
}

//****************** Forces Section ***********************************//
// Here, we customize the forces for every special entities.
//   The net modification force (i.e. due to Princy and Walter's 
//   contributions) is stored in the variable modForce.  
//   This is similar to DEVS state transition functions.
//*********************************************************************//
void modification_Forces(){
  // For each special entity:
  for(int i=0; i<specialIDs.length; i++){
    Entity entity = crowd.getEntities()[specialIDs[i]];    // get the special entity
    PVector pos   = entity.getPosition();                 // get its current position
    PVector modForce = new PVector(0, 0, 0);              // modification net force (starts empty)
    
    int num_flockmates = 0;                               // holds the number of neighbours/flockmates based on flockRadius
    PVector separationForce = new PVector(0, 0, 0);      // holds the separation force
    PVector cohesionForce = new PVector(0, 0, 0);        // holds the cohesion force
    PVector alignmentForce = new PVector(0, 0, 0);       // holds the alignment force
    
    //ModFlocking loop: query my neighbours
    for(int j=0; j<specialIDs.length; j++){                  // this loop is required as the forces are calculated depending on all the neighbours
      if(i==j) continue;                                     // do not calculate for self
      Entity flockmate = crowd.getEntities()[specialIDs[j]]; // get the special entities

      // calculate the distance to determine whether the boid can be consideres flockmate depending on flockRadius 
      PVector posMate  = flockmate.getPosition();  
      float dist = PVector.sub(posMate, pos).mag();
      
      if(j != i && dist > 0 && dist < flockRadius ){        // do not calculate for self
        
        // add the forces of the neighbours
        separationForce.x += flockmate.getPosition().x - entity.getPosition().x; 
        separationForce.y += flockmate.getPosition().y - entity.getPosition().y; 
        
        cohesionForce.x += flockmate.getPosition().x;
        cohesionForce.y += flockmate.getPosition().y;
        
        alignmentForce.x += flockmate.getVelocity().x;
        alignmentForce.y += flockmate.getVelocity().y;
        
        num_flockmates++;
      }
    }
    
    // Calculate flocking forces
    if(num_flockmates != 0){
      separationForce.x /= num_flockmates;  //get the average of all the neighbour/flockmates(j)  positions from selected boid(i)
      separationForce.y /= num_flockmates;
      
      separationForce.x *= -1;            // multiply by -1 as we want separation
      separationForce.y *= -1;
      
      cohesionForce.x /= num_flockmates;  //get the average positions depending on all the neighbour/flockmates(j)  positions
      cohesionForce.y /= num_flockmates;
      
      cohesionForce.x -= entity.position.x;  // get the position of boid(i) from the avarage position 
      cohesionForce.x -= entity.position.x;
      
      alignmentForce.x /= num_flockmates;    // get the average of all neighbor/flockmates(j) velocities
      alignmentForce.y /= num_flockmates;
     
      // Normalize all three vectors calculated
      separationForce.normalize();  // final separation force separating the selected boid(i) from all neighbors/flockmates(j)
      separationForcesArray[i] = separationForce;  // used for visualization in modification_Visualization()
      
      cohesionForce.normalize();    // final cohesion force bringing the selected boid(i) close to neighbors/flockmates(j) 
      cohesionForcesArray[i] = cohesionForce; // used for visualization in modification_Visualization()
      
      alignmentForce.normalize();   // final alignment force aligning the velocity of selected boid(i) to all the neighbors/flockmates(j) 
      alignmentForcesArray[i] = alignmentForce; // used for visualization in modification_Visualization()
    } 
    //ModFlocking
    
    
    // Gathering force towards avg group position = groupAvgPosition - currentPosition
    PVector gatheringForce = PVector.sub(groupAvgPosition, pos).limit(1);  // limited to magnitude 1
    
    // Force towards mouse position = mousePosition - currentPosition
    PVector mouseForce = PVector.sub(mousePosition, pos).limit(1);  // limited to magnitude 1
    
    // Attraction to initial position (useful when wanting to make the particles stay in place)
    //  force = initialPosition - currentPosition  // limited to magnitude 1
    PVector attractionToInitPositionForce = PVector.sub(initialPositions[i], pos).limit(1); 
    
    // Gentle swaying force (i.e. entities move slightly while standing still)
    PVector gentleSwayForce = new PVector ( cos(random(PI)), cos(random(PI)) );
    
    // Collision avoidance force towards voro centroid = centroidPosition - currentPosition
    PVector voroForce = PVector.sub(entity.getCentroidPosition(), pos).limit(1); 
    
    // Friction force is a fraction of the inverse of current velocity
    PVector frictionForce = PVector.mult(entity.getVelocity(),-0.7);
   
   //ModFlocking
    PVector crossHorizontalForce = PVector.sub(horizontalEnd, pos).limit(1);
    modForce.add(crossHorizontalForce.mult(1));
    // Build the net modification force (simply add the forces you want)
    //  and scale the effect of each force using any custom 
    //  multiplication factor inside mult(). To ignore a force, either
    //  comment it out or set its multiplication factor to 0
    modForce.add(voroForce.mult(1));  
    //modForce.add(frictionForce.mult(1));
    //modForce.add(gatheringForce.mult(.8));
    //modForce.add(mouseForce.mult(0.5));
    //modForce.add(gentleSwayForce.mult(0.5));  
    //modForce.add(attractionToInitPositionForce.mult(0.5));
    
    
    //ModFlocking
    // The flags gives the option of disabling and re-enabling any of three steering forces. 
    // Can be controlled by prsessing keyboard keys: Cntrl for cohesionForce, Shift for separationForce and Alt for alignmentForce 
    if(separationFlag){
      modForce.add(separationForce.mult(separationWeight));
    }
    if(cohesionFlag){
    modForce.add(cohesionForce.mult(cohesionWeight));
    }
    if(alignmentFlag){
    modForce.add(alignmentForce.mult(alignmentWeight));
    }
    // Apply the net mod force to the entity, and update its position
    entity.setForce(modForce.mult(0.1)).updatePositionMod(); 
  }

}

//****************** Visualization Section ****************************//
// Here, we alter how the special entities are displayed on the screen.
//  These modifications are drawn on top of the base voro cones.
//*********************************************************************//
void modification_Visualization(){
  // Create some colors we might use (Red, Green, Blue, Alpha) 0-255 each
  color specialHighlight    = color(250,170,20,240);  // special entity highlight color 
  color specialHighlightMet = color(20,250,30,240);   // highlight color if they've met
  color mouseHighlight      = color(100,240,10,255);  // mouse position highlight
  
  // Heighlight the special entities
  if(meetingOccured)
    fill(specialHighlightMet); // Set the fill color
  else
    fill(specialHighlight); // Set the fill color
  // For each special entity:
  for(int i=0; i<specialIDs.length; i++){
    PVector pos = crowd.getEntities()[specialIDs[i]].getPosition(); // get entity position
    ellipse(pos.x, pos.y, CONE_RADIUS, CONE_RADIUS);  // draw a highlighting circle
  }
  
  // Highlight mouse position
  fill(mouseHighlight); // set the fill color
  pushMatrix();
    translate(mousePosition.x, mousePosition.y); rotate(radians(45));
    rectMode(CENTER); 
    rect(0, 0, CONE_RADIUS, CONE_RADIUS); 
  popMatrix();
  
  //ModFlocking : draw the flocking forces for debugging and visualization
  for(int i=0; i<specialIDs.length; i++){
    PVector pos = crowd.getEntities()[specialIDs[i]].getPosition(); // get entity position
    color redArrow = color(250,50,30);  // create a red color (R:250, G:50, B:30)
    stroke(redArrow);                      // set the stroke color to red
    line(pos.x, pos.y, pos.x+20*separationForcesArray[i].x, pos.y+20*separationForcesArray[i].y);
    line(pos.x, pos.y, pos.x+20*cohesionForcesArray[i].x, pos.y+20*cohesionForcesArray[i].y);
    line(pos.x, pos.y, pos.x+20*alignmentForcesArray[i].x, pos.y+20*alignmentForcesArray[i].y);
    noStroke();     //reset stroke color
  }

}

// Draw the scene obstacles
void modification_DrawObstacles(){
    PGraphics ds = canvas.drawingSurface;  // get drawing surface
    ds.pushMatrix();     // initialize drawing matrix
  
    // Draw canvas frame (always)
    float pad = CONE_RADIUS*1.5;     //frame thickness
    ds.translate(0,0,100);
    ds.noStroke();
    ds.fill(ID_TO_COLOR(-5));
    ds.rect(0,0, ds.width, pad);
    ds.rect(0,0, pad, ds.height);
    ds.rect(0,ds.height-pad, ds.width, pad);
    ds.rect(ds.width-pad,0, pad, ds.height); 
    
    // Draw rest of obstacles based on obstacleChoice
    switch(obstacleChoice){
      case 1: // Gate Obstacle
        ds.rect(150 ,ds.height/2,ds.width/2 ,3*CONE_RADIUS); 
        break;
      case 2: // Barricade Obstacle
        ds.rect(350 ,330,ds.width/2 ,2*CONE_RADIUS,10);  
        ds.rect(0,400,230,2*CONE_RADIUS, 10);
        ds.rect(350 ,470,ds.width/2 ,2*CONE_RADIUS,10); 
        break;
      case 3: // Barricade Obstacle Ocasion
        ds.rect(50,400,80,2*CONE_RADIUS, 10);  
        ds.rect(200,400,80,2*CONE_RADIUS, 10); 
        ds.rect(330,400,80,2*CONE_RADIUS, 10); 
        ds.rect(470,400,80,2*CONE_RADIUS, 10);
        break;
      case 4: // Obstacle from PNG image file (scaled to fill the screen)
        ds.image(obstacleMap, 0, 0, (float(width)/obstacleMap.width)  * obstacleMap.width, 
                                    (float(height)/obstacleMap.height)* obstacleMap.height );
      default: 
        break;
    }
    
    ds.popMatrix();  // finalize drawing matrix
}


//******************* User Interface Section ***************************//
// Here, we handle user input events, particularly keyboard presses.
//**********************************************************************//
void keyPressed() {
  // If pressed key is special (see: https://processing.org/reference/keyCode.html)
  if(key == CODED) {
    switch(keyCode){
      case LEFT:    /* do something interesting when left arrow pressed */; break;
      case RIGHT:   /* do something interesting when right arrow pressed*/; break;
      case UP:      /* do something interesting when up arrow pressed*/;    break;
      case DOWN:    /* do something interesting when down arrow pressed*/;  break;
      //ModFlocking
      case ALT:     alignmentFlag = !alignmentFlag;  println("Alignment: "+ alignmentFlag); break;
      case SHIFT:   separationFlag = !separationFlag; println("Separation: "+ separationFlag); break;
      case CONTROL: cohesionFlag = !cohesionFlag; println("Cohesion: "+ cohesionFlag); break;
    }
  }
  else switch(key) {  // else it's a normal key
    case '0': obstacleChoice = 0; break;
    case '1': obstacleChoice = 1; break;
    case '2': obstacleChoice = 2; break;
    case '3': obstacleChoice = 3; break;
    case '4': obstacleChoice = 4; break;    
    case 'r': case 'R': crowd.softReset(false, INITIAL_DISTRIBUTION); 
                        break;
    case 'a': case 'A': DISPLAY_PRESSURE^=true; break;
    case 's': case 'S': DISPLAY_OBJECTIVE^=true; break;
    case 'd': case 'D': MOUSE_DETRACT*=-1; break;
    case ' ': if(looping) noLoop(); else loop(); break;  // spacebar toggles simulation loop
    default:  break;
  }
}