/*******************************************************************
*
*  DESCRIPTION: Atomic Model Gate
*
*  AUTHOR: Sixuan Wang
*
*  EMAIL: mailto://swang@sce.carleton.ca
*
*  DATE: 15/10/2012
*
*******************************************************************/

#ifndef __Gate_H
#define __Gate_H

//#include <list>
#include "atomic.h"     // class Atomic

class Gate : public Atomic
{
public:
	Gate( const string &name = "Gate" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &capaIn;
	Port &out;
	Port &miss;
	Time period;
	float probability;
	int pID;
	//int missID;
	bool sentable;


};	// class Gate

// ** inline ** // 
inline
string Gate::className() const
{
	return "Gate" ;
}

#endif   //__GATE_H
