/*******************************************************************
*
*  DESCRIPTION: Atomic Model Gate
*
*  AUTHOR: Sixuan Wang
*
*  EMAIL: mailto://swang@sce.carleton.ca
*
*  DATE: 15/10/201S2
*
*******************************************************************/

/** include files **/
#include "gate.h"      // class Queue
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: Gate
* Description: 
********************************************************************/
Gate::Gate( const string &name )
: Atomic( name )
, capaIn( addOutputPort( "capaIn" ) )
, out( addOutputPort( "out" ) )
, miss( addOutputPort( "miss" ) )
, period( 0, 0, 10, 0 )
, probability (0.0)
{
	string time( MainSimulator::Instance().getParameter( description(), "period" ) ) ;
	if( time != "" )
		period = time ;

	string prob( MainSimulator::Instance().getParameter( description(), "probability" ) ) ;
	if( prob != "")
		probability = atof(prob.c_str());

}

/*******************************************************************
* Function Name: initFunction
* Description: Resetea la lista
* Precondition: El tiempo del proximo evento interno es Infinito
********************************************************************/
Model &Gate::initFunction()
{
	pID = 0;
	//missID = 0;
	sentable = true;
	holdIn( active, period );
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &Gate::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == capaIn )
	{
		int i = static_cast < int > (msg.value());
		if (i == 0)
			sentable = false;
		else
			sentable = true;
	}

	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &Gate::internalFunction( const InternalMessage & )
{
	holdIn( active, period );
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &Gate::outputFunction( const InternalMessage &msg )
{
	if ((double)rand() / (double) RAND_MAX  <= probability) { //people come
		pID++;
		if (sentable) {  //can receive
			sendOutput(msg.time(), out, pID);
		} else {           //cannot receive
			//missID++;
			sendOutput(msg.time(), miss, pID);
		}
	}
	return *this ;
}
