/*******************************************************************
*
*  DESCRIPTION: Atomic Model Floor1
*
*  AUTHOR: Sixuan Wang
*
*  EMAIL: mailto://swang@sce.carleton.ca
*
*  DATE: 15/10/2012
*
*******************************************************************/

#ifndef __Floor1_H
#define __Floor1_H

//#include <list>
#include "atomic.h"     // class Atomic
#include <map>
#include <string>

using namespace std;

class Floor1 : public Atomic
{
public:
	Floor1( const string &name = "Floor1" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );
	bool isQueueEmpty();
	bool isQueueFull();
	int getSmallestDuePerson();

private:
	const Port &in;
	const Port &capaIn;
	Port &out;
	Port &capaOut;
	Port &occuOut1;
	Time visitingTime;

	int visitingQueueSize;
	typedef map<int, Time> VisitingQueue;
	VisitingQueue visitingQueue;

	int currentPID;
	Time currentDuration;   //for current person time control

	bool receivable;  //can receive, not full
	bool sentable;    //can sent, controled by input
	bool receivableLast; //last time is receivable or not, reduce output msg duplication

	float occupation; //occu%, caculate before deleting
//	Time lastOccuCalTime; //last time that calculated the occupation

};	// class Floor1

// ** inline ** // 
inline
string Floor1::className() const
{
	return "Floor1" ;
}

#endif   //__Floor1_H
