/*******************************************************************
*
*  DESCRIPTION: Atomic Model Floor2
*
*  AUTHOR: Sixuan Wang
*
*  EMAIL: mailto://swang@sce.carleton.ca
*
*  DATE: 15/10/2012
*
*******************************************************************/

#ifndef __Floor2_H
#define __Floor2_H

//#include <list>
#include "atomic.h"     // class Atomic
#include <map>
#include <string>

using namespace std;

/** forward declarations **/
class Distribution ;

class Floor2 : public Atomic
{
public:
	Floor2( const string &name = "Floor2" );					//Default constructor
	~Floor2 ();

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );
	bool isQueueEmpty();
	bool isQueueFull();
	int getSmallestDuePerson();

private:
	const Port &in;
	Port &out;
	Port &capaOut;
	Port &occuOut2;

	Distribution * dist;
	Distribution &distribution()
		{return *dist;}

	int visitingQueueSize;
	typedef map<int, Time> VisitingQueue;
	VisitingQueue visitingQueue;

	int currentPID;
	Time currentDuration;   //for current person time control

	bool receivable;  //can receive, not full
	bool receivableLast; //last time is receivable or not

	float occupation; //occu%, caculate when deleting
//	Time lastOccuCalTime; //last time that calculated the occupation

};	// class Floor2

// ** inline ** // 
inline
string Floor2::className() const
{
	return "Floor2" ;
}

#endif   //__Floor2_H
