/*******************************************************************
*
*  DESCRIPTION: Atomic Model Floor1
*
*  AUTHOR: Sixuan Wang
*
*  EMAIL: mailto://swang@sce.carleton.ca
*
*  DATE: 15/10/201S2
*
*******************************************************************/

/** include files **/
#include "floor1.h"      // class Queue
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )
#include  <stdlib.h>

/** public functions **/

/*******************************************************************
* Function Name: Floor1
* Description: 
********************************************************************/
Floor1::Floor1( const string &name )
: Atomic( name )
, in( addOutputPort( "in" ) )
, capaIn( addOutputPort( "capaIn" ) )
, out( addOutputPort( "out" ) )
, capaOut( addOutputPort( "capaOut" ) )
, occuOut1( addOutputPort( "occuOut1" ) )
, visitingTime( 0, 0, 20, 0 )
, visitingQueueSize (10)
, currentDuration( 0, 0, 0, 0)
{
	string time( MainSimulator::Instance().getParameter( description(), "visitingTime" ) ) ;
	string size( MainSimulator::Instance().getParameter( description(), "queueSize" ) ) ;
	if( time != "" )
		visitingTime = time ;
	if( size != "")
		visitingQueueSize = atoi(size.c_str());
}

/*******************************************************************
* Function Name: initFunction
* Description: Resetea la lista
* Precondition: El tiempo del proximo evento interno es Infinito
********************************************************************/
Model &Floor1::initFunction()
{
	receivable = true;
	sentable = true;
	receivableLast = true;
	occupation = 0.0;
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &Floor1::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == capaIn)
	{
		int sentableV = static_cast < int > (msg.value());
		if(sentableV==0) sentable = false;
		else sentable = true;

		if(currentDuration > msg.time())
			holdIn(active, currentDuration - msg.time());  //remaining time
		else holdIn(active, Time::Zero);
	}
	if( msg.port() == in && !isQueueFull())
	{
		int id = static_cast < int > (msg.value());
		Time t1 (msg.time());
		Time t2 (visitingTime);
		Time t = t1 + t2;

		visitingQueue.insert(pair<int,Time>(id, t));

		if(state()==passive) { //first person, run internal directly
			currentPID = id;
			currentDuration = t;
			holdIn(active, t2);
		}
		else if(isQueueFull()) { //full, set receivable and inform Gate to stop
			receivable = false;
			holdIn(active, Time::Zero);
		}
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &Floor1::internalFunction( const InternalMessage &msg )
{
	if(!receivable && sentable) {
		if(currentDuration > msg.time())  //current one doesn't finish
			holdIn(active, currentDuration - msg.time());
		else { //current one finish
			receivable = true; //go to following
			holdIn(active, Time::Zero);
		}
	}else if(!isQueueEmpty() && sentable) {//queue is not empty && can sent
		map<int ,Time>::iterator iterOld = visitingQueue.find(currentPID); //find the smallest
		visitingQueue.erase(iterOld);  //remove from map

		if(!isQueueEmpty()) {//queue is still not empty
			currentPID = getSmallestDuePerson();
			map<int ,Time>::iterator iter = visitingQueue.find(currentPID); //find the smallest
			currentDuration = iter->second;
			if(currentDuration > msg.time())
				holdIn(active, iter->second - msg.time());  //remaining time
			else holdIn(active, Time::Zero);  //some one is waiting to send, pick him (should be sent earlier, due to !sentable)
		} else {
			this-> passivate();
		}
	}
	else
		this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &Floor1::outputFunction( const InternalMessage &msg )
{
	if(!receivable) {
		if(receivableLast) {
			sendOutput(msg.time(), capaOut, 0);
			receivableLast = false;
		}
	} else if(!isQueueEmpty() && sentable) {//queue is not empty

		occupation = (float)visitingQueue.size()/(float)visitingQueueSize;
		sendOutput(msg.time(), occuOut1, occupation);

		sendOutput(msg.time(), out, currentPID);

		if(!receivableLast) {  //reduce duplication. only sent receivalte that is different than previous
			sendOutput(msg.time(), capaOut, 1);
			receivableLast = true;
		}
	}

	return *this ;
}

/*******************************************************************
* Function Name: isQueueEmpty
* Description:
********************************************************************/
bool Floor1::isQueueEmpty() {
	if(visitingQueue.size()==0) return true;
	else return false;
}

/*******************************************************************
* Function Name: isQueueFull
* Description:
********************************************************************/
bool Floor1::isQueueFull() {
	if(visitingQueue.size()==visitingQueueSize) return true;
	else return false;

}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
int Floor1::getSmallestDuePerson() {
	Time tmp1, tmp2;
	int result = 0;

	map <int, Time>::iterator iter;
	for (iter = visitingQueue.begin(); iter != visitingQueue.end(); iter++) {
		if(iter == visitingQueue.begin()){ //first one
			tmp1 = iter->second;
			result = iter->first;
		} else {
			tmp2 = iter->second;
			if(tmp2 < tmp1){
				tmp1 = tmp2;  //find smallest one
				result = iter->first;
			}
		}
	}
	return result;
}



