/*******************************************************************
*
*  DESCRIPTION: Atomic Model Exit
*
*  AUTHOR: Sixuan Wang
*
*  EMAIL: mailto://swang@sce.carleton.ca
*
*  DATE: 15/10/2012
*
*******************************************************************/

#ifndef __Exit_H
#define __Exit_H

//#include <list>
#include "atomic.h"     // class Atomic

class Exit : public Atomic
{
public:
	Exit( const string &name = "Exit" );					//Default constructor

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &occuIn1;
	const Port &occuIn2;
	Port &throughPut;
	Port &occuOut1;
	Port &occuOut2;

	Time preparationTime;
	int throughPutV;
	float occupation1;
	Time occu1LastTime;
	float occupation2;
	Time occu2LastTime;

	bool tpOut;
	bool o1Put;
	bool o2Put;

};	// class Exit

// ** inline ** // 
inline
string Exit::className() const
{
	return "Exit" ;
}

#endif   //__GATE_H
