class RenderView {
  private PVector position;     // camera 3D position
  private PVector aim;          // camera aim position
  private PVector up;           // camera up vector
  private PVector orthoProj;    // ortho projection properties
  private PVector perspProj;    // perspective projection properties
  private boolean isOrtho;      // flag for ortho vs. perp projections

  RenderView() {
    position = new PVector();
    aim = new PVector();
    up = new PVector();
    orthoProj = new PVector(); 
    perspProj = new PVector(); 
    isOrtho = true;
  }

  RenderView(PVector pos, PVector aim, PVector up, boolean isOrtho) {
    this();
    this.isOrtho = isOrtho;
    this.position = pos.copy();
    this.aim = aim.copy();
    this.up = up.copy();
  }

  //-------------
  // Getters 
  //-------------
  PVector getPosition() {
    // copy() to avoid leaking a private reference.
    // Might change this later.
    return this.position.copy();
  }

  PVector getAim() {
    return this.aim.copy();
  }

  PVector getUp() {
    return this.up.copy();
  }

  //-------------
  // Setters 
  //--------------
  RenderView setCamera(PVector pos, PVector aim, PVector up) {
    this.position = pos.copy();
    this.aim = aim.copy();
    this.up = up.copy();
    return this; // for method chaining
  }

  RenderView setUp(PVector up) {
    this.up = up.copy();
    return this; // for method chaining
  }

  RenderView setAim(PVector aim) {
    this.aim = aim.copy();
    return this; // for method chaining
  }

  RenderView setPosition(PVector pos) {
    this.position = pos.copy();
    return this; // for method chaining
  }
}