class Entity {
  private int entityID;
  private Softicle collision_softicle;
  //private Softicle cohesion_softicle;
  private PVector force;
  private PVector velocity;
  private PVector position;
  private PVector centroidPosition;
  private PVector initialPosition;
  private PVector scale;
  private PVector orientation;
  private color colorCode;
  private float pressure;
  private PVector destinationPosition;
  private float comfortSpeed;
  private PVector positionOld;
  private PVector velocityOld;
  private boolean collided;
  private int cooldown=0; //[ModDistracted]
  //private long lifespan;
  //private ArrayList<Constraint> constraints;
  //private ArrayList<Goal> goals;
  //private ArrayList<Entity> friends;
  //private Personality personality;

  Entity(PVector p, PVector v, int id){
    entityID = id;
    this.position = p.copy();
    this.initialPosition = p.copy();
    this.centroidPosition = new PVector();
    this.velocity = v.copy();
    this.force = new PVector(0,0,0);
    this.colorCode = ID_TO_COLOR(entityID);
    this.collision_softicle = new Softicle(generateShape(this.colorCode));
    this.pressure = 0;
    this.orientation = new PVector(0,1,0);
    this.comfortSpeed = 0.5 + random(-.2,0.4);
    this.destinationPosition = this.position.get();
    this.collided = false;
  }

  Entity(PVector p, PVector v, int id, Softicle col) {
    this(p,v,id);
    this.collision_softicle = col;
  }
  
  //-------------
  // Methods 
  //--------------
  Entity updatePosition(){
    // Preserve previous frame values
    positionOld = position.copy();
    velocityOld = velocity.copy();
    velocity.add(force).limit(comfortSpeed); // limited by this entity's walking speed
    position.add(velocity);
    return this; // method chaining
  }
  
  Entity updatePositionMod(){
    // Restore previous frame values
    position = positionOld.copy();
    velocity = velocityOld.copy();
    velocity.add(force).limit(comfortSpeed); // limited by this entity's walking speed
    position.add(velocity);
    return this; // method chaining
  }

  //-------------
  // Getters 
  //-------------
  int getID() {
    return this.entityID;
  }
  int getCooldown() {
    return this.cooldown;
  }

  color getColorCode() {
    return this.colorCode;
  }

  PVector getPosition() {
    // copy() to avoid leaking a private reference.
    // Might change this later.
    //return this.position.copy();
    return this.position; // [todo] unsafe! but faster for now
  }

  PVector getInitialPosition() {
    return this.initialPosition; 
  }

  PVector getVelocity() {
    return this.velocity;
  }

  PVector getForce(){
    return this.force;
  }

  float getPressure(){
    return this.pressure;
  }

  PVector getCentroidPosition() {
    return this.centroidPosition; // [todo] unsafe! but faster for now
  }
  
  PVector getOrientation() {
    return this.orientation;
  }
  
  PVector getDestinationPosition() {
    return this.destinationPosition;
  }
  
  PVector getDestinationVector() {
    return PVector.sub(this.destinationPosition,this.position);
  }

  PShape getCollisionShape() {
    return this.collision_softicle.getBaseShape();
  }
  
  boolean getCollided(){
    return this.collided;
  }

  //-------------
  // Setters 
  //--------------
  Entity setPosition(PVector p) {
    this.position = p.copy();
    return this; // for method chaining
  }
    Entity setCooldown(int newcool) {
    this.cooldown = newcool;
    return this; // for method chaining
  }
  
  Entity setPositionZ(float z) {
    this.position.z = z;
    return this; // for method chaining
  }
  
  Entity setInitialPosition(PVector iP) {
    this.initialPosition = iP.copy();
    return this; // for method chaining
  }
  
  Entity setForce(PVector f) {
    this.force = f.copy();
    return this; // for method chaining
  }

  Entity setVelocity(PVector v) {
    this.velocity = v.copy();
    return this; // for method chaining
  }
  
  Entity setPressure(float p) {
    this.pressure = p;
    return this; // for method chaining
  }

  Entity setOrientation(PVector r) {
    this.orientation = r.copy();
    return this; // for method chaining
  }
  
  Entity setDestinationPosition(PVector d) {
    this.destinationPosition = d.copy();
    return this; // for method chaining
  }

  Entity setCentroidPosition(PVector cP) {
    this.centroidPosition = cP.copy();
    return this; // for method chaining
  }

  Entity setCollisionSofticle(Softicle s) {
    this.collision_softicle = s;
    return this; // for method chaining
  }

  Entity setCollisionShape(PShape shape) {
    this.collision_softicle.setBaseShape(shape);
    return this; // for method chaining
  }
  
  Entity setCollided(boolean col) {
    this.collided = col;
    return this; // for method chaining
  }
  
}