// For the SYSC5104 course in Fall 2016, supervised by Dr. Gabriel Wainer
//
// Mods.pde:  This file includes the modifications by Princy and Walter 
//            to model grouping, uncooperative and gathering behaviour.
//            Plus, added the ability to load obstacles from a PNG image
//            file.
//

//****************** Global Variables Section ************************//
//********************************************************************//
int[] specialIDs;                // A list of IDs of the modified entities
PVector[] initialPositions;      // A list of their initial positions 
PVector groupAvgPosition;        // Keeps track of the average of special entity positions
PVector mousePosition;           // Keeps track of mouse position
boolean meetingOccured;          // Becomes true if the special entities have met/gathered
PImage obstacleMap;              // Holds an image of the obstacle map
int obstacleChoice;              // Choice of multiple available obstacles
boolean recordTimeToMeeting=false;     // Enable printing of Time-To-Meeting (in seconds)
boolean recordCollisions= true;     // Enable printing of Collision count [ModDistracted]
int WIDTH = 500, HEIGHT = 700;   // Canvas dimensions (1 pixel = 10cm in real life)
// Non-special entities initial distribution (see EntitySystem.initializePositions for options)
String NONSPECIAL_INIT_DISTRIBUTION = "bidirectional";
// Are they in bidirectional flow, or standing still
boolean NONSPECIAL_BIDIRECTIONAL = true;      
// Simulation starts paused?
boolean START_PAUSED = false;


//****************** State Initialization Section ****************************//
// Specify special entity IDs, intitial positions, etc. Runs once on startup.
// This section is similar to CellDEVS inital value (.val) files.
//****************************************************************************//
void modification_Initialization(){
  
  // Specify the number of special entities [ModDistracted]
   int size=96;
   specialIDs = new int[size];
   for(int i=0;i<size;i++)
    {
        specialIDs[i] = i;
    }

   initialPositions = new PVector[specialIDs.length]; // allocate empty array
   for(int i=0; i<specialIDs.length/2; i++){
     initialPositions[i] = new PVector(random(0.05*width, 0.95*width), random(0.05*height, height/3));
     // Rejection Sampling
     while(canvas.drawingSurface.get((int)initialPositions[i].x, (int)initialPositions[i].y) == COLOR_TO_ID(-5)){
       initialPositions[i] = new PVector(random(0.05*width, 0.95*width), random(0.05*height, height/3));
     }
   }
   for(int i=specialIDs.length/2; i<specialIDs.length; i++){
     initialPositions[i] = new PVector(random(0.05*width, 0.95*width), random(height/1.5, 0.95*height));
     // Rejection Sampling
     while(canvas.drawingSurface.get((int)initialPositions[i].x, (int)initialPositions[i].y) == COLOR_TO_ID(-5))
       initialPositions[i] = new PVector(random(0.05*width, 0.95*width), random(height/2, 0.95*height));
   }
  
  // Apply the initialPositions array to the special entities
  for(int i=0; i<specialIDs.length; i++){
    crowd.getEntities()[specialIDs[i]].setPosition(initialPositions[i]);  
    crowd.getEntities()[specialIDs[i]].setInitialPosition(initialPositions[i]);
    //crowd.getEntities()[specialIDs[i]].setDestinationPosition(initialPositions[i]);
  }
  
  // Specify custom obstacle map 
  obstacleMap = loadImage("obstacle1.png");
  obstacleChoice = 0;  
}


//****************** Update Section **********************************//
// Compute the following once every frame. These are useful values. 
//   Whether they actually get used or not, that's up to the modeler, 
//   but they are computed every frame anyway, in case they are needed
//********************************************************************//
void modification_Update(){
  // Update mouse position
  mousePosition = new PVector (mouseX, mouseY, 0);
  
  // Compute the average position of special entities 
  groupAvgPosition = new PVector(0,0,0); // initialize empty vector
  for (int i=0; i<specialIDs.length; i++) {
    groupAvgPosition.add(crowd.getEntities()[specialIDs[i]].getPosition());
  }
  groupAvgPosition.div(specialIDs.length);  // Avg = sum.dividedBy(count);
  
  // Compute whether the special entities have met or not
  meetingOccured = false;        // assume not at first
  float left = width, right=0;   // bounding box of the group
  float top = height, bottom=0;
  for (int i=0; i<specialIDs.length; i++) {
    PVector pos = crowd.getEntities()[specialIDs[i]].getPosition();
    if(pos.x < left  ) left   = pos.x;
    if(pos.x > right ) right  = pos.x;
    if(pos.y < top   ) top    = pos.y;
    if(pos.y > bottom) bottom = pos.y;
  }
  float boundingBoxWidth = right-left;
  float boundingBoxHeight= bottom-top;
  float closeEnoughDistance = specialIDs.length * CONE_RADIUS * 0.7;
  if( (boundingBoxWidth < closeEnoughDistance) && (boundingBoxHeight < closeEnoughDistance) ){
    meetingOccured = true;  // If the bounding box of special entities is small enough, they've met! 
  }
  
  // Print the Time-to-Meeting?
  if(recordTimeToMeeting && meetingOccured){
    // Time advance is 50ms of real time; So 1 second = 20 frames
    String elapsedTime = String.format("%.3f", frameCount/20.0); // to 3 decimal places
    println("Time-to-meeting = " + elapsedTime + " seconds");
    recordTimeToMeeting = false; // done recording it, don't want to run this again
  }
 //[ModDistracted]
  if(recordCollisions){
  // Print COLLISION COUNT
    println("COLLISION COUNT = " + COLLISIONCOUNT/2 + " collisions"); // divide collisions by 2 because each collision involves 2 entities
  }
  
}

//****************** Forces Section ***********************************//
// Here, we customize the forces for every special entities.
//   The net modification force (i.e. due to Princy and Walter's 
//   contributions) is stored in the variable modForce.  
//   This is similar to DEVS state transition functions.
//*********************************************************************//
void modification_Forces(){
  PGraphics ds = canvas.drawingSurface;    // get drawing surface
  // For each special entity:
  for(int i=0; i<specialIDs.length; i++){
    Entity entity = crowd.getEntities()[specialIDs[i]];    // get the special entity
    PVector pos   = entity.getPosition();                 // get its current position
    PVector modForce = new PVector(0, 0, 0);    // modification net force (starts empty)
    
    // velocity Change [ModDistracted]
    PVector v1 = entity.getVelocity(); // get the original velocity
    PVector v2 = v1.mult(0.8); // reduce max velocity by 20% (around 50% reduction to comfort speed)
    entity.setVelocity(v2); // apply it to the distracted entity
    
    // Gathering force towards avg group position = groupAvgPosition - currentPosition
    PVector gatheringForce = PVector.sub(groupAvgPosition, pos).limit(1);  // limited to magnitude 1
    
    // Force towards mouse position = mousePosition - currentPosition
    PVector mouseForce = PVector.sub(mousePosition, pos).limit(1);  // limited to magnitude 1
    
    // Attraction to initial position (useful when wanting to make the particles stay in place)
    //  force = initialPosition - currentPosition  // limited to magnitude 1
    PVector attractionToInitPositionForce = PVector.sub(initialPositions[i], pos).limit(1); 
    
    // Gentle swaying force (i.e. entities move slightly while standing still)
    PVector gentleSwayForce = new PVector ( cos(random(PI)), cos(random(PI)) );
   
    //[ModDistracted]
    // Find Centroid when on phone (with reduced awareness of PS) [ModDistracted]
    entity.setCentroidPosition(new PVector(0, 0));    // Reset centroid calc
    int hits = 0, w = ds.width, h = ds.height;
    float s = CONE_RADIUS+1;  // search radius box
    float x = entity.getPosition().x, y= entity.getPosition().y;
    int x1 = (int)clamp(x-s, 0, w), y1 = (int)clamp(y-0.8*s, 0, h); //top-left corner
    int x2 = (int)clamp(x+s, 0, w), y2 = (int)clamp(y+0.8*s, 0, h); //bot-right corner
    for (int xx=x1; xx<=x2; xx++) { // Iterate over local neighbourhood (Personal Space) 
      for (int yy=y1; yy<=y2; yy++) {
        if (ds.get(xx, yy)==entity.getColorCode()) {//check for color match 
          entity.getCentroidPosition().add(xx, yy, 0);
          hits++;// total number of color matches
        }
      }
    }
    entity.getCentroidPosition().div(hits);
    //[ModDistracted]
    //Unidirecional pathing force for special entities
    PVector destination = new PVector(0, ds.height*0.25-y, 0).limit(3).mult(0.1); 
    //Bidirecional pathing force for special entities
    PVector bipolarForce = new PVector(0, ds.height*(i>floor(specialIDs.length*0.5)?0.15:0.85)-y, 0).limit(3).mult(0.1);
    
    // Collision avoidance force towards voro centroid = centroidPosition - currentPosition
    PVector voroForce = PVector.sub(entity.getCentroidPosition(), pos).limit(1); 
    // Friction force is a fraction of the inverse of current velocity
    PVector frictionForce = PVector.mult(entity.getVelocity(),-0.7);
    
    // Build the net modification force (simply add the forces you want)
    //  and scale the effect of each force using any custom 
    //  multiplication factor inside mult(). To ignore a force, either
    //  comment it out or set its multiplication factor to 0
    modForce.add(voroForce.mult(0.5));  
    modForce.add(frictionForce.mult(1));
//  modForce.add(gatheringForce.mult(.8));
    //modForce.add(mouseForce.mult(.8));
    //modForce.add(gentleSwayForce.mult(0.5));  
    //modForce.add(attractionToInitPositionForce.mult(0.5));
    modForce.add(bipolarForce.mult(1));
    
    // Apply the net mod force to the entity, and update its position
    entity.setForce(modForce.mult(0.1)).updatePositionMod(); 
  }
}

//****************** Visualization Section ****************************//
// Here, we alter how the special entities are displayed on the screen.
//  These modifications are drawn on top of the base voro cones.
//*********************************************************************//
void modification_Visualization(){
  // Create some colors we might use (Red, Green, Blue, Alpha) 0-255 each
  color specialHighlight    = color(250,170,20,240);  // special entity highlight color 
  color specialHighlightMet = color(20,250,30,240);   // highlight color if they've met
  color mouseHighlight      = color(100,240,10,255);  // mouse position highlight
  color collisionDetected   = color(250, 50,50,200);  // red for collision detection
  // Heighlight the special entities
  if(meetingOccured)
    fill(specialHighlightMet); // Set the fill color
  else
    fill(specialHighlight); // Set the fill color
    
  // [ModDistracted] For each special entity: 
  for(int i=0; i<specialIDs.length; i++){
    Entity entity = crowd.getEntities()[specialIDs[i]];
    PVector pos = entity.getPosition(); // get entity position
    if (entity.getCollided())
      fill(collisionDetected); // Set the fill color
    else
      fill(specialHighlight); // Set the fill color
      
    ellipse(pos.x, pos.y, CONE_RADIUS, CONE_RADIUS);  // draw a highlighting circle
  }
  // [ModDistracted] For each non-special entity: 
    for(int i=0; i<CROWDCOUNT; i++){
    Entity entity = crowd.getEntities()[i];
    PVector pos = entity.getPosition(); // get entity position
    if (entity.getCollided()){
      fill(collisionDetected); // Set the fill color
      ellipse(pos.x, pos.y, CONE_RADIUS*.6, CONE_RADIUS*.6);  // draw a highlighting circle
    }
  }
  
  // Highlight mouse position
  //fill(mouseHighlight); // set the fill color
  //translate(mousePosition.x, mousePosition.y); rotate(radians(45));
  //rectMode(CENTER); 
  //rect(0, 0, CONE_RADIUS, CONE_RADIUS); 
}

// Draw the scene obstacles
void modification_DrawObstacles(){
    PGraphics ds = canvas.drawingSurface;  // get drawing surface
    ds.pushMatrix();     // initialize drawing matrix
  
    // Draw canvas frame (always)
    float pad = CONE_RADIUS*1.5;     //frame thickness
    ds.translate(0,0,100);
    ds.noStroke();
    ds.fill(ID_TO_COLOR(-5));
    ds.rect(0,0, ds.width, pad);
    ds.rect(0,0, pad, ds.height);
    ds.rect(0,ds.height-pad, ds.width, pad);
    ds.rect(ds.width-pad,0, pad, ds.height); 
    
    // Draw rest of obstacles based on obstacleChoice
    switch(obstacleChoice){
      case 1: // Gate Obstacle
        ds.rect(150 ,ds.height/2,ds.width/2 ,3*CONE_RADIUS); 
        break;
      case 2: // Barricade Obstacle
        ds.rect(350 ,330,ds.width/2 ,2*CONE_RADIUS,10);  
        ds.rect(0,400,230,2*CONE_RADIUS, 10);
        ds.rect(350 ,470,ds.width/2 ,2*CONE_RADIUS,10); 
        break;
      case 3: // Barricade Obstacle Ocasion
        ds.rect(50,400,80,2*CONE_RADIUS, 10);  
        ds.rect(200,400,80,2*CONE_RADIUS, 10); 
        ds.rect(330,400,80,2*CONE_RADIUS, 10); 
        ds.rect(470,400,80,2*CONE_RADIUS, 10);
        break;
      case 4: // Obstacle from PNG image file (scaled to fill the screen)
        ds.image(obstacleMap, 0, 0, (float(width)/obstacleMap.width)  * obstacleMap.width, 
                                    (float(height)/obstacleMap.height)* obstacleMap.height );
      default: 
        break;
    }
    
    ds.popMatrix();  // finalize drawing matrix
}


//******************* User Interface Section ***************************//
// Here, we handle user input events, particularly keyboard presses.
//**********************************************************************//
void keyPressed() {
  // If pressed key is special (see: https://processing.org/reference/keyCode.html)
  if(key == CODED) {
    switch(keyCode){
      case LEFT:    /* do something interesting when left arrow pressed */; break;
      case RIGHT:   /* do something interesting when right arrow pressed*/; break;
      case UP:      /* do something interesting when up arrow pressed*/;    break;
      case DOWN:    /* do something interesting when down arrow pressed*/;  break;
      case ALT:     /* do something interesting when alt is pressed*/;   break;
      case SHIFT:   /* do something interesting when shift is pressed*/; break;
      case CONTROL: /* do something interesting when ctrl is pressed*/; break;
    }
  }
  else switch(key) {  // else it's a normal key
    case '0': obstacleChoice = 0; break;
    case '1': obstacleChoice = 1; break;
    case '2': obstacleChoice = 2; break;
    case '3': obstacleChoice = 3; break;
    case '4': obstacleChoice = 4; break;    
    case 'r': case 'R': crowd.softReset(false, INITIAL_DISTRIBUTION); 
                        break;
    case 'a': case 'A': DISPLAY_PRESSURE^=true; break;
    case 's': case 'S': DISPLAY_OBJECTIVE^=true; break;
    case 'd': case 'D': MOUSE_DETRACT*=-1; break;
    case ' ': if(looping) noLoop(); else loop(); break;  // spacebar toggles simulation loop
    default:  break;
  }
}