class EntitySystem {
  private Entity entities[];
  private PVector origin;
  //private Softicle shapes[];
  private Softicle defaultSofticle;
  private ArrayList<Softicle> softicles;

  EntitySystem(PVector origin, int count){this(origin,count,"");}
  EntitySystem(PVector origin, int count, String defaultShape) {
    this.origin = origin.copy();
    this.entities = new Entity[count];  // or arraylist
    // Create default voronoi uniform conic shape
    this.defaultSofticle = new Softicle(generateShape(defaultShape));    // save it
  }

  //-------------
  // Getters 
  //-------------
  void appendEntity(Entity e) {
    //this.entities.add(e)/append(e); //which?
  }

  Entity[] getEntities(){
    return this.entities; // reference, not copy. Risky.
  }

  //-------------
  // Setters 
  //--------------
  EntitySystem setDefaultSofticle(Softicle s){
    this.defaultSofticle = s;
    return this; // for method chaining
  }

  EntitySystem setAllSofticlesShape(String type){
    for(int i=entities.length; i-->0;)
      entities[i].setCollisionSofticle(new Softicle(
        generateShape( type, entities[i].getColorCode())
      ));
    return this; // for method chaining
  }

  //-------------
  // Methods 
  //--------------
  EntitySystem initializePositions(String mode){
    // [todo] implement rejection sampling to avoid landinng on obstancles
    PVector[] positions = new PVector[entities.length];
    if (mode == "line"){
      for(int i=entities.length; i-->0;)
        positions[i] = new PVector(i*5,40,0);
    }else if(mode=="half"){
      for(int i=entities.length; i-->0;)
        positions[i] = new PVector(random(CONE_RADIUS*1.4,width/1.5),
                                   random(CONE_RADIUS*1.4,height/2.1),0);
    }else if(mode=="dot"){
      for(int i=entities.length; i-->0;)
        positions[i] = new PVector(width*SUBPIXELS/2,height*SUBPIXELS/1.5,0);
    }else if(mode=="topHalf"){
      for(int i=entities.length; i-->0;)
        positions[i] = new PVector(random(CONE_RADIUS,width-CONE_RADIUS),
                                   random(CONE_RADIUS,height/2.1-CONE_RADIUS),0);
    }else if(mode=="radialShutter"){
      float thickness = 60, radius=width/4, posX=width/2, posY=width/2, jitter=10;
      for(int i=entities.length; i-->0;){
        float tubeRadius = radius + random(thickness);
        positions[i] = new PVector(posX+sin(i)*tubeRadius+random(jitter),
                                   posY-cos(i)*tubeRadius+random(jitter),0);
      }
    }
    else if(mode=="bidirectional" || mode=="bipolar"){
      //int a=0 ;
      for(int i=CROWDCOUNT; i-->floor(CROWDCOUNT*0.5);)  // half down
      {
        positions[i] = new PVector(random(CONE_RADIUS*1.5,width-CONE_RADIUS*1.5),
                                   random(CONE_RADIUS*1.5,height*0.3-CONE_RADIUS*1.5),0); 
    } 
      for(int i=floor(CROWDCOUNT*0.5); i-->0;) // half up
      {
              positions[i] = new PVector(random(CONE_RADIUS*1.5,width-CONE_RADIUS*1.5),
                                   random(height*0.6+CONE_RADIUS*1.5,height-CONE_RADIUS*1.5),0);  
      }
                            
    }
    else if(mode=="quadpolar"){
      for(int i=floor(CROWDCOUNT); i-->floor(CROWDCOUNT*0.75);) // top left
        positions[i] = new PVector(random(width*0.1, width*0.25),
                                   random(width*0.1, width*0.25),0);
      for(int i=floor(CROWDCOUNT*0.75); i-->floor(CROWDCOUNT*0.5);) // top right
        positions[i] = new PVector(random(width*0.75, width*0.9),
                                   random(width*0.1, width*0.25),0);
      for(int i=floor(CROWDCOUNT*0.5); i-->floor(CROWDCOUNT*0.25);) // bottom left
        positions[i] = new PVector(random(width*0.1, width*0.25),
                                   random(width*0.75, width*0.9),0);
      for(int i=floor(CROWDCOUNT*0.25); i-->0;)  // bottom right
        positions[i] = new PVector(random(width*0.75, width*0.9),
                                   random(width*0.75, width*0.9),0);
    }
    else if(mode=="makka"){
      float side = 160;
      for(int i=entities.length; i>0;){
        float x = random(CONE_RADIUS*5,width-CONE_RADIUS*5),
        y = random(CONE_RADIUS*5,height-CONE_RADIUS*5);
        if (x>0.5*(width-side) && x<0.5*(width+side) && y>0.5*(height-side) && y<0.5*(height+side)){
          i = i;
        }else{
          i--;
          positions[i] = new PVector(x,y,0); 
        }
      }
    }
    else if(mode=="old"){ //[old]
      for(int i=entities.length; i-->0;)
        positions[i] = new PVector(random(40, width-20),
                                   random(40, 200), 0);     
    }
    else { // default random
      for(int i=entities.length; i-->0;)
        positions[i] = new PVector(random(CONE_RADIUS,width-CONE_RADIUS),
                                   random(CONE_RADIUS,height-CONE_RADIUS),0);
    }
    
    // Initialize entities with positions[]
    initializePositions( positions );
    
    for(int i=entities.length; i-->0;)
        entities[i].setDestinationPosition(new PVector(random(CONE_RADIUS,width-CONE_RADIUS),
                                           random(CONE_RADIUS,height-CONE_RADIUS),0) );
    
    return this; // for method chaining
  }

  EntitySystem initializePositions(){ // no parameter = assume random initiazlization
    initializePositions("uniformRandomCover");
    return this; // for method chaining
  }

  EntitySystem initializePositions(PVector[] pos){
    for(int i=entities.length; i-->0;)
      entities[i] = new Entity(pos[i], new PVector(), i);  
    return this; // for method chaining
  }

  EntitySystem softReset(){softReset(false); return this;}
  EntitySystem softReset(boolean reset){softReset(reset, ""); return this;}
  EntitySystem softReset(boolean reset, String mode){
    if (reset)
      initializePositions(mode);
    else{
      for(int i=entities.length; i-->0;){
        entities[i].setPosition(entities[i].getInitialPosition());
        entities[i].setVelocity(new PVector());
      }
    }
    return this; // for method chaining
  }
}