/*******************************************************************
*
*  DESCRIPTION: Healtgy Smile Dental Clinic
*
*  AUTHOR: Ekambir Sidhu + Manohar Deep Singh Gill
*
*******************************************************************/

#ifndef __receptionist_H
#define __receptionist_H

#include <list>
#include "atomic.h"   

class receptionist : public Atomic
{
public:
	receptionist( const string &name = "receptionist" );
	virtual ~receptionist() { delete [] reqList; }
	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &in;
	const Port &nxtpatcall;
	Port &out;
	Port &rdy;	
	typedef list<Value> ElementList ;
	ElementList elements;
	int *reqList;
	int nxtpatcall_count;
	int max_doctors;
	int get_doctor_id();

};

inline
string receptionist::className() const
{
	return "receptionist" ;
}
#endif 