/*******************************************************************
*
*  DESCRIPTION: Healthy Smile Dental Clinic
*
*  AUTHOR: Ekambir Sidhu + Manohar Deep Singh Gill
*******************************************************************/

/** include header files **/
#include "doctor.h"        
#include "message.h"
#include "mainsimu.h"      
#include "distri.h"        


/*******************************************************************
* Function Name: doctor
********************************************************************/
doctor::doctor( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, rdy( addInputPort( "rdy" ) )
, out( addOutputPort( "out" ) )
, nxtpatcall( addOutputPort( "nxtpatcall" ) )
{

string id( MainSimulator::Instance().getParameter( description(), "myId" ) ) ;
myId = atoi(id.data()); 
	
try
{
dist = Distribution::create( MainSimulator::Instance().getParameter( description(), "distribution" ) );
MASSERT( dist ) ;
for ( register int i = 0; i < dist->varCount(); i++ )
	{
	string parameter( MainSimulator::Instance().getParameter( description(), dist->getVar( i ) ) );
	dist->setVar( i, str2Value( parameter ) ) ;
	}

} catch( InvalidDistribution &e )
	{
	e.addText( "The model " + description() + " has distribution problems!" ) ;
	e.print(cerr);
	MTHROW( e ) ;
} catch( MException &e )
	{
	MTHROW( e ) ;
	}

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model& doctor::initFunction()
{
ready = false;
holdIn( active, Time::Zero);
return *this ;
}

/*******************************************************************
* Function Name: externalFunction
********************************************************************/
Model& doctor::externalFunction( const ExternalMessage &msg )
{
if ((this->state() == passive) && (msg.port() == rdy) && (myId == (int) msg.value()))
	{
	ready = true;
	}
else if ((this->state() == passive) && (msg.port() == in) && (ready == true))
	{
	value = msg.value();
	double service_time = fabs( distribution().get());
	if (service_time > 0)
		service_time = 3600000/service_time;
	else
		service_time = 0;
	holdIn(active, Time(0,0,0,service_time)) ;
	}

return *this;
}

/*******************************************************************
* Function Name: internalFunction
********************************************************************/
Model& doctor::internalFunction( const InternalMessage & )
{
ready = false;
passivate();
return *this ;
}

/*******************************************************************
* Function Name: outputFunction
********************************************************************/
Model &doctor::outputFunction( const InternalMessage &msg )
{

if (ready == true) 
	sendOutput( msg.time(), out, value) ;

sendOutput( msg.time(), nxtpatcall, myId) ;

return *this ;
}
/*******************************************************************
* Function Name: 
********************************************************************/
doctor::~doctor ()
{ 
delete dist;
}
