/*******************************************************************
*
*  DESCRIPTION: Comptroller 
*
*  AUTHOR: Ekambir Sidhu + Manohar Deep Singh Gill
*
*
*******************************************************************/

#ifndef __comptroller_H
#define __comptroller_H

#include "atomic.h"     
#include "time.h"
#include <list>

class comptroller : public Atomic
{
public:
	comptroller( const string &name = "comptroller" );

	virtual string className() const ;
protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &enter_sys;
	const Port &exit_q;
	const Port &exit_sys;
	const Port &in;
	Port &epc;
	Port &epq;
	Port &wtq;
	Port &wtc;
	int in_sys, out_q, out_sys;
	float epc_val, epq_val, wtq_val, wtc_val;
	void calculate_epq();
	void calculate_wtq(const Time &time);
	void calculate_epc();
	void calculate_wtc(const Time &time);
	typedef list<Time> TimeStamps;
	TimeStamps arrivalTimesepq; 
	TimeStamps arrivalTimeswtc;  
	float convertTimeToHrs(const Time &time);
};

inline
string comptroller::className() const
{
return "comptroller" ;
}
#endif
