/*******************************************************************
*
*  DESCRIPTION: Healthy Smile Dental Clinic Model
*
*  AUTHOR: Ekambir Sidhu + Manohar Deep Singh Gill
*
*******************************************************************/

/** include header files **/
#include "receptionist.h"     
#include "message.h"    
#include "mainsimu.h"
#include <stdlib.h>

/** public functions **/

/*******************************************************************
* Function Name: receptionist
********************************************************************/
receptionist::receptionist( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, nxtpatcall( addInputPort( "nxtpatcall" ) )
, out( addOutputPort( "out" ) )
, rdy( addOutputPort( "rdy" ) )
{
string doctors( MainSimulator::Instance().getParameter( description(), "doctors" ) ) ;

max_doctors = atoi(doctors.data());

if (max_doctors <= 0)
	max_doctors = 10;

reqList = new int[max_doctors];
MASSERT (reqList != 0);

cout<<endl<<"The receptionist can be connected with ";
if (max_doctors == 1)
	cout<<"only "<<max_doctors<<"doctor";
else
cout<<max_doctors<<" doctors";
cout<<endl<<endl;

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &receptionist::initFunction()
{

for (int doctor_id=0; doctor_id<max_doctors; doctor_id++)
	reqList[doctor_id] = 0;

nxtpatcall_count = 0;
elements.erase( elements.begin(), elements.end() ) ;

return *this ;
}

/*******************************************************************
* Function Name: externalFunction
********************************************************************/
Model &receptionist::externalFunction( const ExternalMessage &msg )
{
if( msg.port() == in )
	{
	elements.push_back( msg.value() ) ;
      	if ((elements.size() == 1) && (nxtpatcall_count > 0))
		holdIn( active, Time::Zero);
	else if (nxtpatcall_count == 0)
		passivate();
	}

if( (msg.port() == nxtpatcall ) && (msg.value() >= 0) && (msg.value() < max_doctors))
	{
	reqList[(int)msg.value()] = 1;
	
	nxtpatcall_count++;
	
	if ((nxtpatcall_count == 1) && (elements.size() > 0))
		holdIn( active, Time::Zero);
	
	else if (elements.size() == 0)
		passivate();	
	}

return *this;
}

/*******************************************************************
* Function Name: internalFunction
********************************************************************/
Model &receptionist::internalFunction( const InternalMessage & )
{

elements.pop_front();

if ((nxtpatcall_count >0) && (elements.size() > 0))
	holdIn( active, Time::Zero);
else
	passivate();

return *this ;
}

/*******************************************************************
* Function Name: outputFunction
********************************************************************/
Model &receptionist::outputFunction( const InternalMessage &msg )
{
int doctor_id = get_doctor_id();

if (doctor_id >= 0)
	{
	sendOutput( msg.time(), rdy, (double)doctor_id); 
	sendOutput( msg.time(), out, elements.front()); 
	}

return *this ;
}
/*******************************************************************
* Function Name: get_doctor_id
********************************************************************/

int receptionist::get_doctor_id()
{

for (int doctor_id=0; doctor_id<max_doctors; doctor_id++)
	{
	if (reqList[doctor_id] == 1) 
		{
		reqList[doctor_id] = 0;
		nxtpatcall_count--;
		return doctor_id;
		}
	}
return -1;
}
