#ifndef BOOST_SIMULATION_PDEVS_BM_CROSSED_CARS_H 
#define BOOST_SIMULATION_PDEVS_BM_CROSEED_CARS_H

#include <string>
#include <vector>
#include <assert.h>
#include <boost/simulation/pdevs/atomic.hpp>
#include "types.hpp"
#include "britime.hpp"

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;


class crossed_cars : public pdevs::atomic<BRITime, Message_t> {

private:
    string              _ID;        
    string              _TL_id_resonsible;
    BRITime             _ta;
    BRITime             _time_to_cross;
    string              _state;
    vector<string>      _car_line_ids_responsible;
    BRITime             _in_yellow_car;
    BRITime             _in_yellow_pedestrian;
    BRITime             _delay_to_green;
    BRITime             _time_to_passive;
    BRITime             INF;
    BRITime             INSTANTANEOUS;

public:
   
    explicit crossed_cars (string id,  BRITime time_to_cross, string TL_id_resonsible, vector<string> car_line_ids_responsible, BRITime in_yellow_car, BRITime in_yellow_pedestrian, BRITime delay_to_green) noexcept {

        INF                       = numeric_limits<BRITime>::infinity();
        INSTANTANEOUS             = BRITime(1, 1000000);
        _ID                       = id;
        _TL_id_resonsible         = TL_id_resonsible; 
        _ta                       = INF;     
        _time_to_cross            = time_to_cross;   
        _state                    = string("passive");
        _car_line_ids_responsible = car_line_ids_responsible;
        _in_yellow_car            = in_yellow_car;
        _in_yellow_pedestrian     = in_yellow_pedestrian;
        _delay_to_green           = delay_to_green;
        _time_to_passive          = BRITime(0);
      
     }

    void internal() noexcept {

      if( _state == string("transition")){
        _time_to_passive =  _time_to_passive - _ta; 
        if( _time_to_passive > 0){
        _ta = _time_to_cross; 
        } else {
          _ta = INF;
          _state = string("passive");
        }
      }else if (_state == string("active")){
          _ta = _time_to_cross;  

      }                  
     }
   
    BRITime advance() const noexcept {
        
        return _ta; 
    }
   
    vector<Message_t> out() const noexcept { 
          
      vector<Message_t> output;
      Message_t msg;
      if(_state != string("passive")){
         msg.from = _ID;
         msg.to = _car_line_ids_responsible;
         msg.amount = 1;
        output.push_back(msg);
      }   
      
      return output;
        
    }
        
    void external(const vector<Message_t>& mb, const BRITime& t) noexcept { 
     
      bool member_tl_id_of_mb_to = false; // variable that states if tl_id_responsible is member of mb[0].to
      
      for (int i = 0; i < mb[0].to.size(); i++){
        if(_TL_id_resonsible == mb[0].to[i]){
          member_tl_id_of_mb_to = true;
        }
      }

      if (member_tl_id_of_mb_to == true){
        _state = string("active");
        _ta = _in_yellow_pedestrian + _in_yellow_car + _delay_to_green;
      } else{
        _state = string("transition");
        _time_to_passive = _in_yellow_pedestrian;

        if((_ta - t) > 0){
          _ta = _ta - t;
        }else{
          _ta = _time_to_cross;
        }       
        
      }
    }
   
         
    void confluence(const vector<Message_t>& mb, const BRITime& t)  noexcept  { 
        external (mb, t); 

     }

};

#endif // BOOST_SIMULATION_PDEVS_BM_CAR_REMOVER_H