#ifndef BOOST_SIMULATION_PDEVS_BM_COORDINATOR_TL_H
#define BOOST_SIMULATION_PDEVS_BM_COORDINATOR_TL_H

#include <string>
#include <vector>
#include <assert.h>
#include <boost/simulation/pdevs/atomic.hpp>
#include "types.hpp"
#include "britime.hpp"

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;

class coordinator_traffic_ligth : public pdevs::atomic<BRITime, Message_t> {

private:
    string              _ID;
    BRITime             _ta;
    vector<Message_t>   _output;
    BRITime             INF;
    BRITime             INSTANTANEOUS;

public:
   
    explicit coordinator_traffic_ligth (string id) noexcept {

        INF                       = numeric_limits<BRITime>::infinity();
        INSTANTANEOUS             = BRITime(1, 100000);
        _ID                       = id;
        _ta                       = INF;        
                    
     }

    void internal() noexcept {
        _output.clear();
        _ta = INF;
     
     }
   
    BRITime advance() const noexcept {
        
        return _ta; 
    }
   
    vector<Message_t> out() const noexcept { 
          return _output;
        
    }
        
    void external(const vector<Message_t>& mb, const BRITime& t) noexcept { 
        Message_t aux_msg_1;
        Message_t aux_msg_2;
        _output.clear();
        bool member_CTL1_of_mb_to = false; // variable that states if CTL1 is member of mb[0].to
        bool member_CTL2_of_mb_to = false;
        bool member_PTL1_of_mb_to = false;
        bool member_PTL2_of_mb_to = false;

      for (int i = 0; i < mb[0].to.size(); i++){
        if(mb[0].to[i] == string("CTL1")){
           member_CTL1_of_mb_to = true;
        }else if(mb[0].to[i] == string("CTL2")){
            member_CTL2_of_mb_to = true;
        }

         if(mb[0].to[i] == string("PTL1")){
           member_PTL1_of_mb_to = true;
        }else if(mb[0].to[i] == string("PTL2")){
            member_PTL2_of_mb_to = true;
        }
      }

        if ( member_CTL1_of_mb_to){
            aux_msg_1.to.push_back(string("CTL1"));
            aux_msg_1.from = _ID;
            aux_msg_1.information = string("green");
            if (member_PTL1_of_mb_to){
                aux_msg_1.to.push_back (string("PTL1"));
            }
             aux_msg_2.to.push_back(string("CTL2"));
             aux_msg_2.to.push_back(string("PTL2"));
             aux_msg_2.from = _ID;
             aux_msg_2.information = string("red");
        }
        else if ( member_CTL2_of_mb_to){
            aux_msg_1.to.push_back(string("CTL2"));
            aux_msg_1.from = _ID;
            aux_msg_1.information = string("green");
            if (member_PTL2_of_mb_to){
                aux_msg_1.to.push_back (string("PTL2"));
            }
             aux_msg_2.to.push_back(string("CTL1"));
             aux_msg_2.to.push_back(string("PTL1"));
             aux_msg_2.from = _ID;
             aux_msg_2.information = string("red");
        }

        _output.push_back(aux_msg_1);
        _output.push_back(aux_msg_2);
        _ta = INSTANTANEOUS;
    }
         
    void confluence(const vector<Message_t>& mb, const BRITime& t)  noexcept  { 
        assert(false && "The definition of the model only allows reciving an instruction to change the state when th coordinator is stable");
     }

};

#endif // BOOST_SIMULATION_PDEVS_BM_COORDINATOR_TL_H