#ifndef BOOST_SIMULATION_PDEVS_BM_TRAFFIC_CONTROLLER_H 
#define BOOST_SIMULATION_PDEVS_BM_TRAFFIC_CONTROLLER_H

#include <string>
#include <vector>
#include <assert.h>
#include <boost/simulation/pdevs/atomic.hpp>
#include "types.hpp"
#include "britime.hpp"
#include <random>

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;

class traffic_controller : public pdevs::atomic<BRITime, Message_t> {

private:

    string            _ID;
    BRITime           _ta;
    string            _car_state;
    string            _pedestrian_state;
    string            _pb_state_1;
    string            _pb_state_2;
    bool              _sending;
    BRITime           _cycle_time;   
    string            _auxiliar;
    BRITime           INF;
    BRITime           INSTANTANEOUS; 
        
public:
   
    explicit traffic_controller (string id, BRITime cycle_time) noexcept {

        INF                = numeric_limits<BRITime>::infinity();
        INSTANTANEOUS      = BRITime(1, 100000); 
        _ID                = id;
        _ta                = 0;
        _car_state         = string("red");
        _pedestrian_state  = string("red");
        _pb_state_1        = string("passive");
        _pb_state_2        = string("passive");
        _sending           = false;
        _cycle_time        = cycle_time;
     }

    void internal() noexcept {

      _auxiliar.clear();
      if (_sending){
        _sending = false;
        _ta = _cycle_time;
      } else{

        _sending = true;
        _ta = INSTANTANEOUS;

        if (_car_state == string("red")){

          _car_state = string("CTL2");

          if (_pb_state_2 == string("active")){

              _pedestrian_state = string("PTL2");
          }else {
             _pedestrian_state = string("red");
          }
        }else if (_car_state == string("CTL1")){

          _car_state = string("CTL2");
          if (_pedestrian_state == string("PTL1")){

              _auxiliar = string("PB1");
          }
          if (_pb_state_2 == string("active")){

              _pedestrian_state = string("PTL2");
          }else {

              _pedestrian_state = string("red");
          }
        }else if (_car_state == string("CTL2")){

          _car_state = string("CTL1");
          if (_pedestrian_state == string("PTL2")){
              
              _auxiliar = string("PB2");
          }
          if (_pb_state_1 == string("active")){

              _pedestrian_state = string("PTL1");
          }else {

              _pedestrian_state = string("red");
          }
        }
      }      
    }
   
    BRITime advance() const noexcept {
        
        return _ta; 
    }
   
    vector<Message_t> out() const noexcept { 
      vector<Message_t> output;
      Message_t msg_a;
      Message_t msg_b;

      if(_sending){
        msg_a.from = _ID;
        msg_a.to.push_back(_car_state);
        msg_a.to.push_back(string("CC1"));
        msg_a.to.push_back(string("CC2"));
        msg_a.to.push_back(string("TLCo"));

        if(_pedestrian_state != string("red")){
          msg_a.to.push_back(_pedestrian_state);
        }
        msg_a.information = string("green");
        output.push_back(msg_a);
      }

      if(! _auxiliar.empty()){
        msg_b.from = _ID;
        msg_b.to.push_back(_auxiliar);
        output.push_back(msg_b);
      }

     
      return output;
    }
        
    void external(const vector<Message_t>& mb, const BRITime& t) noexcept { 
      
      for (int i = 0; i < mb.size(); i++){

        if((mb[i].from == string("PB1")) && (mb[i].information == string("active"))){

          _pb_state_1 = string("active");
        }else if ((mb[i].from == string("PB2")) && (mb[i].information == string("active"))){

          _pb_state_2 = string("active");
        }else if((mb[i].from == string("PB1")) && (mb[i].information == string("passive"))){

          _pb_state_1 = string("passive");
        }else if ((mb[i].from == string("PB2")) && (mb[i].information == string("passive"))){

          _pb_state_2 = string("passive");
        }
      }

      _ta = _ta - t;

    }
         
    void confluence(const vector<Message_t>& mb, const BRITime& t)  noexcept  { 
         
      if(_ta != INSTANTANEOUS){
        external(mb, t);
        internal();
      } else {
        _sending = false;
        external(mb, t);
        _ta = _cycle_time;

      }
     }

};

#endif // BOOST_SIMULATION_PDEVS_BM_TRAFFIC_CONTROLLER_H
