#ifndef BOOST_SIMULATION_PDEVS_BM_PB_H // Para cada archivo un nombre diferente y dentro de cada archivo siempre el mismo
#define BOOST_SIMULATION_PDEVS_BM_PB_H

#include <string>
#include <iostream>
#include <vector>
#include <assert.h>
#include <boost/simulation/pdevs/atomic.hpp>
#include "types.hpp"
#include "britime.hpp"
#include <random>

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;

class pedestrian_button : public pdevs::atomic<BRITime, Message_t> {

private:

    string      _ID;
    BRITime     _ta;
    string      _state;
    bool        _sending;
    BRITime     INF;
    BRITime     INSTANTANEOUS;
        
public:
   
    explicit pedestrian_button (string id) noexcept {

        INF              = numeric_limits<BRITime>::infinity();
        INSTANTANEOUS    = BRITime(1, 100000); 
        _ID              = id;
        _ta              = INF; 
        _state           = string("passive");
        _sending         = false;
          
     }

    void internal() noexcept {

         _ta = INF; 
         _sending = false;

     }
   
    BRITime advance() const noexcept {
        
        return _ta; 
    }
   
    vector<Message_t> out() const noexcept { 

      vector<Message_t> output;
      Message_t msg;
      if (_sending == true){
      
        msg.to.push_back(string("TC"));
        msg.to.push_back(string("output_model"));
        msg.information = _state;
        msg.from = _ID;
        output.push_back(msg);
      }    
      return output;
    }
        
    void external(const vector<Message_t>& mb, const BRITime& t) noexcept { 

      bool all_mb_from_model_input = true;
      bool all_mb_from_TC = true;
      for (int i = 0; i < mb.size(); i++)
      {
        if (mb[i].from == string("TC")){

          all_mb_from_model_input = false;
        }

        if (mb[i].from == string("model_input")){

          all_mb_from_TC = false;
        }
      }

      if ((all_mb_from_model_input == true) && (_state == string("passive"))){

        _state = string("active");
        _sending = true;
        _ta = INSTANTANEOUS;

      }else if ((all_mb_from_TC == true) && (_state == string("active"))){

        _state = string ("passive");
        _sending = true;
        _ta = INSTANTANEOUS;
      }else if ((all_mb_from_model_input == false) && (all_mb_from_TC == false) ){
        _state = string("active");
        _sending = true;
        _ta = INSTANTANEOUS;
      }     
    }
      
  void confluence(const vector<Message_t>& mb, const BRITime& t)  noexcept  { 

      _sending = false;
        external(mb, t);
  }

};

#endif // BOOST_SIMULATION_PDEVS_BM_PB_H
