#ifndef BOOST_SIMULATION_PDEVS_BM_CAR_LINE_H 
#define BOOST_SIMULATION_PDEVS_BM_CAR_LINE_H

#include <string>
#include <vector>
#include <assert.h>
#include <iostream>
#include <boost/simulation/pdevs/atomic.hpp>
#include "types.hpp"
#include "britime.hpp"
#include <random>

using namespace boost::simulation::pdevs;
using namespace boost::simulation;
using namespace std;

class car_line : public pdevs::atomic<BRITime, Message_t> {

private:

    string            _ID;
    BRITime           _ta;
    vector<BRITime>   _time_items_in_queue;
    bool              _previous_items_in_queue_0;
    BRITime           INF;
    BRITime           INSTANTANEOUS; 
            
public:
   
    explicit car_line (string id) noexcept {

        INF    = numeric_limits<BRITime>::infinity();
        INSTANTANEOUS  = BRITime(1, 100000); 
        _ID                        = id;
        _ta                        = INF; 
        _previous_items_in_queue_0 = true;     
           
     }

    void internal() noexcept {

      if(!_time_items_in_queue.empty()){
        for (int i = 0; i < _time_items_in_queue.size(); i++){

           _time_items_in_queue[i] = _time_items_in_queue[i] + INSTANTANEOUS;

        }
      }

     _ta = INF;
    }
   
    BRITime advance() const noexcept {
        
        return _ta; 
    }
   
    vector<Message_t> out() const noexcept { 

      vector<Message_t> output;
      Message_t msg;
      if (!_time_items_in_queue.empty()){
      
        msg.to.push_back(string("output_model"));
        msg.from = _ID;
        msg.amount = _time_items_in_queue.size();
        msg.timer = _time_items_in_queue[0];
        output.push_back(msg);
      } else if (_previous_items_in_queue_0 == false){
        msg.to.push_back(string("output_model"));
        msg.from = _ID;
        msg.amount = 0;
        msg.timer = 0;
        output.push_back(msg);


      }    
      return output;
    }
        
    void external(const vector<Message_t>& mb, const BRITime& t) noexcept { 
      
      if(!_time_items_in_queue.empty()){

         for (int i = 0; i < _time_items_in_queue.size(); i++){

            _time_items_in_queue[i] = _time_items_in_queue[i] + t;
            _previous_items_in_queue_0 = false;
          }
      } else {

        _previous_items_in_queue_0 = true;
      }

      bool all_mb_from_model_input = true;
      bool all_mb_from_CC1 = true;
      bool all_mb_from_CC2 = true;
      bool msg_CC1_CC2 = false;

      for (int i = 0; i < mb.size(); i++){

       for (int j = 0; j < mb.size(); j++){

         if ((mb[i].from == string("CC1"))&&(mb[j].from == string("CC2"))){

            msg_CC1_CC2 = true;
          }
        }
      } 


      if(msg_CC1_CC2 == true){
      assert(false && "The car line can only recieve messages from a single crossed car model");
      }

      for (int i = 0; i < mb.size(); i++){

        if ((mb[i].from == string("CC1"))|(mb[i].from == string("CC2")) ){

          all_mb_from_model_input = false;
        }

        if ((mb[i].from == string("model_input")) | (mb[i].from == string("CC1")) ){

          all_mb_from_CC2 = false;
        }

        if ((mb[i].from == string("model_input")) | (mb[i].from == string("CC2")) ){

          all_mb_from_CC1 = false;
        }
       }

      if (all_mb_from_model_input == true){

        for(int i = 0; i < mb.size(); i++){

          for (int j = 0; j < mb[i].amount; j++){

            _time_items_in_queue.push_back(0);
          }
        }
      } else if ((all_mb_from_CC1 == true)| (all_mb_from_CC2 == true)){

          for(int i = 0; i < mb.size(); i++){

            for (int j = 0; j < mb[i].amount; j++){

              if (!_time_items_in_queue.empty()){

                _time_items_in_queue.erase(_time_items_in_queue.begin());
              }
            }
        }

      }else {

        for(int i = 0; i < mb.size(); i++){

          if(mb[i].from == string("model_input")){

             for (int j = 0; j < mb[i].amount; j++){

               _time_items_in_queue.push_back(0);
             }
          }
        }

        for(int i = 0; i < mb.size(); i++){

          if((mb[i].from == string("CC1"))| (mb[i].from == string("CC2"))){

             for (int j = 0; j < mb[i].amount; j++){

              if (!_time_items_in_queue.empty()){

                _time_items_in_queue.erase(_time_items_in_queue.begin());
              }
            }
          }
        }
      }  
      _ta = INSTANTANEOUS;     
    }
  
         
    void confluence(const vector<Message_t>& mb, const BRITime& t)  noexcept  { 
             external(mb, t);
     }

};

#endif // BOOST_SIMULATION_PDEVS_BM_CAR_LINE_H
