/*******************************************************************
*
*  DESCRIPTION: Atomic Model TicketWindow
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

/** include files **/
#include "ticketwindow.h"      // class TicketWindow
#include "message.h"    	// class ExternalMessage, InternalMessage
#include "mainsimu.h"   	// MainSimulator::Instance().getParameter( ... )
#include "distri.h"      	  // class Distribution
#include "strutil.h"      	 // str2float( ... )
#include <stdio.h>
#include <stdlib.h>


/** public functions **/

/*******************************************************************
* Function Name: TicketWindow
* Description: Ticket Window is the entrance to the arena, through which audiences can get into the arena
* Each Audience should be charged 5 dollars as entrance fee.
* It will output the total amount of money earned as well as the current audience number.
********************************************************************/
TicketWindow::TicketWindow( const string &name )
: Atomic( name )
, audienceIn( addInputPort( "audienceIn" ) )
, moneyOut( addOutputPort( "moneyOut" ) )
, audienceOut( addOutputPort( "audienceOut" ) )
, timeForAudience( 0, 0, 3, 0 )	//time for audience
{	currentQueue1Num=0; 	//the current queue1 length for audience
	totalQueue1Num=0;		// total audienceIn number, if the accumulated audience number is equal or //larger than 500, the TicketWindow will not work at all because audience seats are full!
	money=0; 				//money =5*audience number
}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &TicketWindow::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &TicketWindow::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == audienceIn  && this->state() == passive)
	{	totalQueue1Num = static_cast < int > (msg.value());
		if (totalQueue1Num > 0)
		{	currentQueue1Num = totalQueue1Num ;
			money=5;
			holdIn(active, timeForAudience );
		}
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &TicketWindow::internalFunction( const InternalMessage & )
{
	if (currentQueue1Num > 0)
		{
			money=money+5;
			if(money>2500)
				currentQueue1Num=1;
			currentQueue1Num--;
			holdIn( active, timeForAudience );
		}
	if(currentQueue1Num==0)
		passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &TicketWindow::outputFunction( const InternalMessage &msg )
{
	sendOutput( msg.time(), moneyOut, money ) ;
	sendOutput( msg.time(), audienceOut, money/5 ) ;
	return *this ;
}
