/*******************************************************************
*
*  DESCRIPTION: Simulator::registerNewAtomics()
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

#include "modeladm.h"
#include "mainsimu.h"
#include "players.h"        // class Players
#include "audience.h"        // class Audience
#include "ticketwindow.h"        // class TicketWindow
#include "score.h"        // class Score
#include "rdumpire.h"	// class Rdumpire
#include "onumpire.h"	// class Onumpire


void MainSimulator::registerNewAtomics()
{

	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<TicketWindow>(), "TicketWindow" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Audience>(), "Audience" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Players>(), "Players" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Score>(), "Score" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Rdumpire>(), "Rdumpire" ) ;
	SingleModelAdm::Instance().registerAtomic( NewAtomicFunction<Onumpire>(), "Onumpire" ) ;
}

