/*******************************************************************
*
*  DESCRIPTION: Atomic Model Onumpire
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

/** include files **/
#include "onumpire.h"// class definition for Onumpire
#include "message.h"    // class ExternalMessage, InternalMessage

/** public functions **/

/*******************************************************************
* Function Name: Onumpire constructor
* Description: This routine constructs the Onumpire model
********************************************************************/
Onumpire::Onumpire( const string &name )
: Atomic( name )
, wicket( addInputPort( "wicket" ) )
, yes_wicket( addOutputPort( "yes_wicket" ) )
{
	out;
	wicketin = 1;
}

/*******************************************************************
* Function Name: Onumpire init function
* Description: This routine is invoked when the simulator starts.  It
* initializes some variables and does nothing else.  The model does not
* begin doing any useful work until "start" is received.
********************************************************************/
Model &Onumpire::initFunction()
{
	this-> passivate();
		return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This routine handles external events coming from the
* input port.  The start_game signal can only be given once; afterward it
* is ignored.
********************************************************************/
Model &Onumpire::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == wicket  && this->state() == passive)
		wicketin =int( (static_cast < long double > (msg.value())));
	{
		if(wicketin == 0)
		{
			out = 0;
		}
		else out = 1;
		holdIn( active, Time::Zero );
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: The internal function increments the period count and
*              sets the timer interval for the next period.
********************************************************************/
Model &Onumpire::internalFunction( const InternalMessage & )
{
	passivate();
		return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: This routine outputs <start_period> or <end_game>
*              depending on the current period count.
********************************************************************/
Model &Onumpire::outputFunction( const InternalMessage &msg )
{
	if(out == 0)
      sendOutput( msg.time(), yes_wicket, out ) ;

	return *this ;
}
