/*******************************************************************
*
*  DESCRIPTION: Atomic Model Audience
*
*  AUTHOR:	Jipson, Antony
*
*  EMAIL: jipsonjohnson@cmail.carleton.ca
*
*  DATE:28/10/2016
*
*******************************************************************/

/** include files **/
#include "audience.h"      // class Audience
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name:Audience
* Description: As to the Audience part, audiences have 2 outputs:
* 'Batting team fans get Excited' if batsman hits a six or four;
* 'Bowling team fans get Excited' if a wicket falls;
* Some of them will decide to leave the park if 7 or more wickets fall.
* The total amount of audiences who still want to watch the game will be shown as an output.
* Another output is the audiences behavior.
********************************************************************/
Audience::Audience( const string &name )
: Atomic( name )
, in( addInputPort( "in" ) )
, audienceIn( addInputPort( "audienceIn" ) )
, out( addOutputPort( "out" ) )
, audienceOut( addOutputPort( "audienceOut" ) )
{	count1=0;
	count2=0;
	audienceNum=0;

}

/*******************************************************************
* Function Name: initFunction
* Description:
* Precondition:
********************************************************************/
Model &Audience::initFunction()
{
	this-> passivate();
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description:
********************************************************************/
Model &Audience::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == audienceIn )
	{
		audienceNum = static_cast < int > (msg.value());
		holdIn( active, Time::Zero );
	}
	if(msg.port() == in)
	{
		if(static_cast < int > (msg.value())==6||static_cast < int > (msg.value())==4){
			count1++;
			count2=0;
			holdIn(active,Time::Zero );
		}
		if( static_cast < int > (msg.value())==0){
			count1=0;
			count2++;
			if(count2>=7){
				if(audienceNum<10)
					audienceNum=0;
				if(audienceNum>=10)
					audienceNum= audienceNum-10;
			}
			holdIn(active,Time::Zero );
		}

	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description:
********************************************************************/
Model &Audience::internalFunction( const InternalMessage & )
{
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description:
********************************************************************/
Model &Audience::outputFunction( const InternalMessage &msg )
{
	sendOutput( msg.time(), audienceOut, audienceNum) ;
	if(count1>0)
		sendOutput( msg.time(), out, 1);
	if(count2>0)
		sendOutput( msg.time(), out, 0);
	return *this ;
}
