/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "GUI_ControllerType.h"           // base header

#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioIdentity;
using namespace RadioState;

/*******************************************************************
* Function Name: GUI_ControllerType
* Description: constructor
********************************************************************/
GUI_ControllerType::GUI_ControllerType( const string &name )
: Atomic( name ),
  Led_Out(addOutputPort( "Led_Out" )),
  Interface_In(addInputPort( "Interface_In" )),
  Button_In(addInputPort( "Button_In" )),
  Crypto_In(addInputPort( "Crypto_In" ))
{
	memset(m_StateOfLed, 0, sizeof( m_StateOfLed));
	memset(m_StateOfCrypto, 0, sizeof( m_StateOfCrypto));
	m_Index = -1;
	nAction = -1;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &GUI_ControllerType::initFunction()
{
	// [(!) Initialize common variables]

	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	myState = Idle;

 	// set next transition
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &GUI_ControllerType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 

 	//Doesn't matter what the other interfaces send until the button controller sends information
 	if(Button_In == msg.port())
 	{
		int value = msg.value();
		nAction = short(msg.value());
		//cout <<"GUI - Button nAction = " << nAction << "\n";

		if( 3 == nAction )
			return *this;

		int temp = 0;
		//cout << "GUI - Button msg.value = " << value << "\n";
		if(value & HF)
			m_Index = 0;
		if( value & VUHF)
			m_Index = 1;
		if( value & FM)
			m_Index = 2;
		if( value & AM)
			m_Index = 3;

		m_StateOfLed[m_Index] = msg.value();
		//cout <<"GUI - Button  m_StateOfLed[m_Index] = " << m_StateOfLed[m_Index] << "\n";

		//Button Controller told us which radio in the upper byte
		//and what the Led lighting effect is to be
		//0 means no Led  on
		//1 means yellow
		//2 means red
		//3 means crypto

		//Get the index

		if( 0 != nAction )
		{
			// yellow to red to yellow to red etc.
			temp = (short)( m_StateOfLed[m_Index] );
			//cout << "****************************************GUI - Button temp = " << temp << "\n";

		}
		else
			m_StateOfLed[m_Index] &= 0xffff0000;

 		//Pack the information for sending
		 m_StateOfLed[m_Index] &= 0xffff0000;

		 // | AM | FM |VUHF| HF |  F | Cr | Tx | Rx |
 		if( 1 == temp )
 		{
 			m_StateOfLed[m_Index] |= 0x1;

 			//cout <<"GUI - Button port - m_StateOfLed[m_Index] = " << m_StateOfLed[m_Index] << "\n";
 		}
 		if( 2 == temp )
 		{
 			m_StateOfLed[m_Index] |= 0x11;
 			//cout <<"GUI - Button_In port - m_StateOfLed[m_Index] = " << m_StateOfLed[m_Index] << "\n";
 		}
       	myState = Button;
 		holdIn( active, Time::Zero  ) ;

 	}

	if( Crypto_In == msg.port() )
 	{
		int value = msg.value();
		//cout <<"Gui - Crypto_In port - msg.value  " << value << "\n";
		//cout <<"GUI - Crypto_In port - m_StateOfLed[m_Index] = " << m_StateOfLed[m_Index] << "\n";
		if ( 0 < m_StateOfLed[m_Index] )
 			m_StateOfCrypto[m_Index] = value;
		if( 1 == (short)m_StateOfCrypto[m_Index] )
		{
 			m_StateOfLed[m_Index] |= 0x100;
 			//cout <<"GUI - Crypto_In port - else 1 m_StateOfLed[m_Index] = " << m_StateOfLed[m_Index] << "\n";
		}

		else
		{
			m_StateOfLed[m_Index] &= ~0x100;
			//cout <<"GUI - Crypto_In port - else 0  m_StateOfLed[m_Index] = " << m_StateOfLed[m_Index] << "\n";
		}

		myState = Crypto;

		holdIn( active, Time::Zero  ) ;

 	}

	if( Interface_In == msg.port() )
 	{
		int value = msg.value();
		int nRadioSelected = 0;
		if( HF & value )
			m_Index = 0;
		if( VUHF & value )
		 	m_Index = 1;
		if( FM & value )
		 	m_Index = 2;
		if( AM & value )
		 	m_Index = 3;
		if(0 <= m_Index && 3 >= m_Index )
		{
			//cout <<"Gui Interface_In port - msg.value ()  " << value << "\n";
			if ( UNKEYED == (short)value )
			{
				//Return to previous unflashing state
				m_StateOfLed[m_Index] &= ~0x0000f000;
				//cout <<"Gui Interface_In port - UNKEYED m_StateOfLed[m_Index]  " << m_StateOfLed[m_Index] << "\n";
			}
			else
			{
				//Report a flashing state if LED is active
				if(0 < (short)m_StateOfLed[m_Index] )
				{
					m_StateOfLed[m_Index] |= 0x1000;
					//cout <<"Gui Interface_In port - KEYED m_StateOfLed[m_Index]  " << m_StateOfLed[m_Index] << "\n";
				}
			}

			myState = Interface;

			holdIn( active, Time::Zero  ) ;
		}


 	}

	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &GUI_ControllerType::internalFunction( const InternalMessage & )
{

	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &GUI_ControllerType::outputFunction( const InternalMessage &msg )
{
	if( Idle != myState)
	{
		sendOutput( msg.time(), Led_Out, m_StateOfLed[m_Index]);
		//cout << "Gui sending to LED m_StateOfLed[m_Index] = " << m_StateOfLed[m_Index] << "\n";
		myState = Idle;
	}
	return *this;

}

GUI_ControllerType::~GUI_ControllerType()
{
}


