/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Crypto_ControllerType.h"           // base header
#include "Declarations.h"
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
using namespace RadioIdentity;


/*******************************************************************
* Function Name: Crypto_ControllerType
* Description: constructor
********************************************************************/
Crypto_ControllerType::Crypto_ControllerType( const string &name )
: Atomic( name ),
  Gui_Out(addOutputPort( "GUI_Out" )),
  Button_In(addInputPort( "Button_In" ))
{

}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Crypto_ControllerType::initFunction()
{
	// [(!) Initialize common variables]

	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	myState = Idle;

 	// set next transition
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Crypto_ControllerType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 
	
 	if( Button_In == msg.port() )
 	{

 		int value = msg.value();
 		//cout << "Crypto - Button_in port msg.value = " << hex << value << "\n";

 		if( value & HF )
			m_Index = 0;
		if( value & VUHF )
			m_Index = 1;

		//cout << "Crypto - Button_in port m_Index = " << m_Index << "\n";
		//Crypto can be on or off depending on the user input
		m_StateOfCrypto[m_Index]  = value;

		myState = Rx;

		holdIn( active, Time::Zero  ) ;
 	}

	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Crypto_ControllerType::internalFunction( const InternalMessage & )
{
	//TODO: implement the internal function here

	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Crypto_ControllerType::outputFunction( const InternalMessage &msg )
{
	if( Rx == myState )
	{
	sendOutput( msg.time(),Gui_Out, m_StateOfCrypto[m_Index]);
	myState = Idle;
	}
	return *this;

}

Crypto_ControllerType::~Crypto_ControllerType()
{
}
