/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "CCU_InterfaceType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioState;



/*******************************************************************
* Function Name: CCU_InterfaceType
* Description: constructor
********************************************************************/
CCU_InterfaceType::CCU_InterfaceType( const string &name )
: Atomic( name ),
  CSU_Out(addOutputPort( "CSU_Out" )),
  Status_Out(addOutputPort( "Status_Out" )),
  Audio_Out(addOutputPort( "Audio_Out" )),
  Keyline_In(addInputPort( "Keyline_In" )),
  Status_In(addInputPort( "Status_In" )),
  CSU_In(addInputPort( "CSU_In" )),
  Audio_In(addInputPort( "Audio_In" )),
  Reception_In(addInputPort( "Reception_In" )),
  Reception_Out(addOutputPort( "Reception_Out" ))

{
	m_StateOfKeyline = 0;
	m_StateOfStatusControl = 0;
	m_StateOfAudio = 0;
	nStatus = 0;
	myState = Idle;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &CCU_InterfaceType::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	// set next transition
 	myState = Idle;
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &CCU_InterfaceType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();
	this->elapsed = msg.time()-lastChange();
	this->timeLeft = this->sigma - this->elapsed;
	

	// m_StateOfControl is a dense populated variable where a 1 per byte indicates
	//operational. Thus 0x11110111 means all radios, not used, audio, valid CSU
	//transmission selection and a keyline respectively.
 	if( Keyline_In == msg.port() )
 	{
 		m_StateOfKeyline = ( m_StateOfControl & 0x11110000);
 		int value = msg.value();
 		m_StateOfKeyline |= value;
 		if( KEYED == value )
 			m_StateOfControl |= 0x1;
 		else
 			m_StateOfControl &= ~0x1;
 		//cout << "CCU keyline,  m_StateOfKeyline  = " << hex << m_StateOfKeyline << " \n";
 		myState = Keyed;
 		holdIn( active, Time::Zero );

 	}
 	if( CSU_In  == msg.port() )
 	{
		//The data is the radios in the upper bytes and the LEDs status
		//in the lower bytes. Right now, the interface is concerned with
		// the lower selection. I.e. whether the LED is off.
		//
 		nValueCsu  = msg.value();
 		//cout << "CCU csu in,  value  = " << nValueCsu << " \n";

		//Transmitting
		if( nValueCsu & 0x10 )
		{
			m_StateOfControl |= 0x11110010;
			myState = Valid;
		}
		else
		{
			m_StateOfControl &= ~0x00000010;
			myState = Invalid;
		}
		//cout << "CCU csu in,  m_StateOfControl  = " << m_StateOfControl << " \n";
		//cout << "CCU csu in,  myState  = " << myState << " \n";
		holdIn( active, Time::Zero );
 	}

 	if( Status_In  == msg.port() )
 	{
		//The Status Controller packs the upper bytes with the
		//status of the radios, so retrieve the states.
 		static int nCounter;
		m_StateOfStatusControl = msg.value();
		//cout << "CCU status in,  m_StateOfStatusControl  = " << m_StateOfStatusControl << " \n";


		nStatus = m_StateOfStatusControl & 0x11110000;
		//cout << " CCC Status getting status of radios " << nStatus << "\n";

 		//cout << "CCU status in,  m_StateOfStatusControl  = " << m_StateOfStatusControl << " \n";
 		if( 3 == nCounter )
		{
			m_StateOfControl |= nStatus;
			//cout << " CCU Status - polled three times for full status \n";
		}
 		else
 		{
 			//Populate the radios states compared to the CSU
			//Remember the CSU can select a radio even if it is not working
			//first shift the two variables down to the lower bytes to ensure no
			//extra information is added

			if( nStatus != 0x11110000)
			{
				//cout << " CCU Status getting status of radios \n";
				m_StateOfStatusControl = 0;
				nCounter++;
				holdIn( active, Time::Zero );
			}
			else
			{
				//cout << " CCU Status - status of radios correct \n";
				m_StateOfControl |= nStatus;
			}
 		}

		holdIn( active, Time::Zero );
 	}

 	if( Audio_In == msg.port() )
 	{

 		m_StateOfAudio = msg.value();
 		if( AUDIO == m_StateOfAudio)
 			m_StateOfControl |= 0x100;
 		else
 			m_StateOfControl &= ~0x100;
 		//cout << " CCU Audio In -  m_StateOfControl = " << m_StateOfControl << "\n";
 		//cout << " CCU Audio In -  m_StateOfAudio = " << m_StateOfAudio << "\n";
 		//Audio in means that a mic was keyed to receive the audio
 		myState = Keyed;
 		holdIn( active, Time::Zero );
 	}

 	//Conditional for reception from any radio
 	if( Reception_In == msg.port() )
	{
 		m_StateOfKeyline = msg.value();
 		//cout << "CCU Reception In m_StateOfAudio = " << m_StateOfKeyline << "\n";
 		myState = Keyed;
		holdIn( active, Time::Zero );
	}
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &CCU_InterfaceType::internalFunction( const InternalMessage & )
{
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );


	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &CCU_InterfaceType::outputFunction( const InternalMessage &msg )
{

	if(0 == m_StateOfStatusControl)
	{
		//Get them
		sendOutput( msg.time(), Status_Out, m_StateOfControl );
		//cout << "CCU Radio was just setup. CCU requesting status = " << m_StateOfStatusControl << " \n";
		return *this;
	}


	if( ( Valid == myState ) )// && ( KEYED == (short)m_StateOfKeyline ))
	{
		//cout << "CCU Sending audio out m_StateOfControl = " << hex << m_StateOfControl << "\n";
		sendOutput( msg.time(), Audio_Out, m_StateOfControl);
		myState = Idle;
	}

	//Check for valid radios
	if( Keyed == myState )
	{

		sendOutput( msg.time(), CSU_Out, m_StateOfKeyline );
		//cout << "CCU Radio - keyed, m_StateOfKeyline is = " << m_StateOfKeyline << " \n";

	}


	return *this;

}

CCU_InterfaceType::~CCU_InterfaceType()
{
}
