/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Button_ControllerType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioIdentity;
using namespace ButtonState;


/*******************************************************************
* Function Name: Button_ControllerType
* Description: constructor
********************************************************************/
Button_ControllerType::Button_ControllerType( const string &name )
: Atomic( name ),
  Crypto_Out(addOutputPort( "Crypto_Out" )),
  Gui_Out(addOutputPort( "GUI_Out" )),
  Interface_In(addInputPort( "Interface_In" ))

{
		memset(m_StateOfCrypto, 0x00 , sizeof( m_StateOfCrypto));
		memset(m_StateOfGui, 0x00, sizeof( m_StateOfGui));
		memset(m_StateOfCsu, 0x00, sizeof( m_StateOfCsu));
		m_Index = -1;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Button_ControllerType::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	// TODO: add init code here. (setting first state, etc)

 	// set next transition
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Button_ControllerType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 

 	if( Interface_In == msg.port() )
 	{
 		input = 0;

 		//Get the number representing the radio as per Declarations.h
 		//THe format is upper bytes selected radio lower bytes the press -
 		//double single or crypto
 		int value = msg.value();
 		//cout << "Button - Interface  msg.value is = " << value << " \n";

 		//m_Index = (value >> 16) - 1;
 		if( HF & value )
 			m_Index = 0;
 		if( VUHF & value )
 		 	m_Index = 1;
 		if( FM & value )
 		 	m_Index = 2;
 		if( AM & value )
 		 	m_Index = 3;
 		m_StateOfCsu[m_Index] = 0;
 		//cout << "Button - Interface  m_Index is = " << m_Index << " \n";
		int temp = value & 0xffff0000;
		//cout << "Button - Interface  selected radio is = " << temp << " \n";

		//Get the action performed
		input = value - temp;
		//cout << "Button - Interface  msg.value is = " << input << " \n";
 		switch(input)
 		{
 				case SINGLE_PRESS:
 					//Off to yellow to red continuously
 					m_StateOfGui[m_Index] = (short)(m_StateOfGui[m_Index]  + 1 ) % 3;
 					if( 0 == m_StateOfGui[m_Index] )
						m_StateOfGui[m_Index] = 1;
					if( 2 == m_StateOfGui[m_Index] )
						m_StateOfPermission[m_Index]  = 1;
					//cout << "Button - Single state m_StateOfGUI[m_Index] is = " << m_StateOfGui[m_Index] << " \n";
					//cout << "Button - Single state m_StateOfPermission[m_Index] is = " << m_StateOfPermission[m_Index] << " \n";
				break;

				case DOUBLE_PRESS:
					m_StateOfGui[m_Index]  = 0;
					m_StateOfPermission[m_Index]  = 0;
					//cout << "Button - Double state m_StateOfCsu[m_Index] is = " << m_StateOfCsu[m_Index] << " \n";
					//cout << "Button - Double state m_StateOfPermission[m_Index] is = " << m_StateOfPermission[m_Index] << " \n";
				break;

				case CRYPTO_PRESS:
					// Crypto can be on or off depending on the user input
					m_StateOfCrypto[m_Index] = (short)(m_StateOfCrypto[m_Index]  + 1) % 2;
					m_StateOfPermission[m_Index] = m_StateOfCrypto[m_Index];
					if( 0 == m_StateOfCrypto[m_Index] )
						m_StateOfPermission[m_Index]  = 0;
					//cout << "Button - Crypto  state m_StateOfCrypto[m_Index] is = " << m_StateOfCrypto[m_Index] << " \n";
					//cout << "Button - Crypto  state m_StateOfPermission[m_Index] is = " << m_StateOfPermission[m_Index] << " \n";
				break;
 		}

		if( 0 == m_Index)
		{
				m_StateOfCsu[m_Index] |= HF;
				//cout << "Button - Interface state m_StateOfCsu[m_Index] is = " << m_StateOfCsu[m_Index] << " \n";
				int temp = (short)m_StateOfGui[m_Index] + (short)m_StateOfCrypto[m_Index];
				//cout << "Button - Interface state temp is = " << temp << " \n";
				m_StateOfCsu[m_Index] |= temp;
				//cout << "Button - Interface state m_StateOfCsu[m_Index] is = " << m_StateOfCsu[m_Index] << " \n";
				m_StateOfCrypto[m_Index] |= HF;
		}
		else if( 1 == m_Index)
		{
				m_StateOfCsu[m_Index] |= VUHF;
				int temp = (short)m_StateOfGui[m_Index] + (short)m_StateOfCrypto[m_Index];
				m_StateOfCsu[m_Index] |= temp;
				m_StateOfCrypto[m_Index] |= VUHF;
		}
		else if( 2 == m_Index)
		{
				m_StateOfCsu[m_Index] |= FM;
				m_StateOfCsu[m_Index] |= m_StateOfGui[m_Index];
		}
		else if( 3 == m_Index)
		{
				m_StateOfCsu[m_Index] |= AM;
				m_StateOfCsu[m_Index] |= m_StateOfGui[m_Index];
		}


		holdIn( active, Time::Zero );

 	}

	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Button_ControllerType::internalFunction( const InternalMessage & )
{

	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;


}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Button_ControllerType::outputFunction( const InternalMessage &msg )
{

	if( 65535 < m_StateOfCsu[m_Index] && 3 != ( short )( m_StateOfCsu[m_Index] ) )
	{
		// The format is 0x00010002 meaning HF is transmitting
		sendOutput(msg.time(), Gui_Out, m_StateOfCsu[m_Index]);
		//cout << "Button sending to GUi_Controller m_StateOfCsu[m_Index] " << m_StateOfCsu[m_Index] << "\n";
	}

	//Let crypto know that there was a button press to send the crypto state
	//which is independent of the user command button selection of a single
	//or double press
	if( CRYPTO_PRESS == input && 1 == m_StateOfPermission[m_Index])
	{
		sendOutput(msg.time(), Crypto_Out, m_StateOfCrypto[m_Index]);
		//cout << "Button sending to crypto m_StateOfCrypto[m_Index] " << m_StateOfCrypto[m_Index] << "\n";
	}

	return *this;

}

Button_ControllerType::~Button_ControllerType()
{
}
