/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Status_ControllerType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioIdentity;
using namespace RadioState;


/*******************************************************************
* Function Name: Status_ControllerType
* Description: constructor
********************************************************************/
Status_ControllerType::Status_ControllerType( const string &name )
: Atomic( name ),
  Interface_Out(addOutputPort( "Interface_Out" )),
  Interface_In(addInputPort( "Interface_In" )),
  ANVDT_In(addInputPort( "ANVDT_In" )),
  ANVDT_Out(addOutputPort( "ANVDT_Out" ))

{

	m_AnvdtState = 0;
	m_RadioState = 0;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Status_ControllerType::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	
 	// set next transition
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Status_ControllerType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 
	
 	if(Interface_In == msg.port() )
 	{
		//The CCU Interface sent a 0 to inform us that there is no status on the //radios
		if( 0 == msg.value() )
		{
			float fRandNum = 0;
			int temp[3] = {0};
			for (int i =0; i <3 ;i++)
			{
				fRandNum  = rand()/(float)RAND_MAX;
				if(0.75 < fRandNum )
					temp[i] = NONOPERATIONAL;
				else
					temp[i] = OPERATIONAL;

			}
			//AM
			if(OPERATIONAL == temp[0])
					m_RadioState |= AM;
			//FM
			if(OPERATIONAL == temp[1])
					m_RadioState |= FM;
			//VUHF
			if(OPERATIONAL == temp[2])
					m_RadioState |= VUHF;
		}
		holdIn( active, Time::Zero );

 	}

 	if( ANVDT_In == msg.port() )
 	{
 		//By default ANVDT gives status
 		m_AnvdtState = msg.value();
 		//cout << "ANDVT_In Status request m_AnvdtState =  " << m_AnvdtState << " \n";
 		if( OPERATIONAL == m_AnvdtState)
 			m_RadioState |= HF;
 		else
 			m_RadioState &= ~HF;

 		holdIn( active, Time::Zero );

 	}

	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Status_ControllerType::internalFunction( const InternalMessage & )
{
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Status_ControllerType::outputFunction( const InternalMessage &msg )
{
	if( OPERATIONAL != m_AnvdtState)
		sendOutput( msg.time(), ANVDT_Out, (short)m_AnvdtState );
	else
	{
		sendOutput( msg.time(), Interface_Out, m_RadioState );
		//cout << "Status sending m_radioState to Interface " << m_RadioState << " \n";
	}

	return *this;

}

Status_ControllerType::~Status_ControllerType()
{
}
