/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "LEDType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator


/*******************************************************************
* Function Name: LEDType
* Description: constructor
********************************************************************/
LEDType::LEDType( const string &name )
: Atomic( name ),
  Gui_In(addInputPort( "Gui_In" )),
  Led_Status_Out(addOutputPort("Led_Status_Out"))
{
	m_StateOfLed = 0;
	m_OldStateOfLed = 0;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &LEDType::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	// set next transition
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &LEDType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 
	

 	if(Gui_In == msg.port() )
 	{
		//The GUI controller sent a message with the appropriate
		//radio head, the crypto, and the states to be
		//A bit manipulation work then be done but the Led is just going
		//to affirm that the action was done and send the GUI Controllers
		//message to the output.

		m_StateOfLed = ( msg.value());
		//cout << "LED got data m_StateOfLed = " << m_StateOfLed << "\n";

		holdIn( active, Time::Zero  ) ;
 	}

	
	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &LEDType::internalFunction( const InternalMessage & )
{
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &LEDType::outputFunction( const InternalMessage &msg )
{
	//In reality the bitmap to display Led colour depending on state would be seen
	//but because Devs is a black box, send the output to the interface for output
	//where a fully packed data value is successful
	//Check to see if it is sent to prevent run away as the LED is always on

	//cout << "Led - out m_OldStateOfLed = " << hex << m_OldStateOfLed << "\n" ;
	//cout << "Led - out m_StateOfLed = " << hex << m_StateOfLed << "\n" ;
	if( m_OldStateOfLed != m_StateOfLed )
	{
		//cout << "Led sending to Interface data = " << hex << m_StateOfLed << "\n" ;
		sendOutput (msg.time(), Led_Status_Out, m_StateOfLed);
		m_OldStateOfLed = m_StateOfLed;
	}

	return *this;

}

LEDType::~LEDType()
{
}
