/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "HF_TransceiverType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "../distri.h"     // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioState;



/*******************************************************************
* Function Name: HF_TransceiverType
* Description: constructor
********************************************************************/
HF_TransceiverType::HF_TransceiverType( const string &name )
: Atomic( name ),
  ANVDT_Out(addOutputPort( "ANVDT_Out" )),
  ANVDT_In(addInputPort( "ANVDT_In" )),
  HF_Audio_Out(addOutputPort( "HF_Audio_Out" )),
  Audio_In(addInputPort( "Audio_In" )),
  HF_Transmission_Out(addOutputPort("HF_Transmission_Out")),
  HF_Reception_In(addInputPort( "HF_Reception_In" ))

{
	myState = Idle;
	double m_StateOfHf = 0;
	double m_RadioTx = 0;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &HF_TransceiverType::initFunction()
{
	// [(!) Initialize common variables]
	//this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	this->sigma = Time::Inf;

 	// set next transition
 	holdIn( active, this->sigma  ) ;
 	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &HF_TransceiverType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	//this->sigma = nextChange();
	//this->elapsed = msg.time()-lastChange();
 	//this->timeLeft = this->sigma - this->elapsed;
	
 	m_RadioTx = 0;

 	if( msg.port() == ANVDT_In )
 	{

 		m_StateOfHf = msg.value();


 		if(DECODED  == m_StateOfHf || ENCODED  == m_StateOfHf )
 		{
 			m_RadioTx = AUDIO;
 			myState = Relay;
 		}
 		else
 			m_RadioTx = NO_AUDIO;
 		myState = Relay;
 		//cout << "Hf_Transceiver received ANVDT data, value = " << m_RadioTx << " \n";
 		holdIn( active, Time::Zero );

 	}

 	if( Audio_In == msg.port() )
 	{
		//We have valid audio and a keyline so generate
		//an output and send it to the ANVDT for encryption

		m_RadioTx = TRANSMISSION;
		myState = Tx;

		//cout << "Hf_Transceiver received user data, value = " << m_RadioTx << " \n";
		holdIn( active, Time::Zero );


 	}
 	if( HF_Reception_In == msg.port() )
 	{
 		//We have a message in so send so store it and send it to the ANVDT for //decryption
		m_RadioTx = DECODED;
		myState = Rx;

		//cout << "Hf_Transceiver received a radio transmission, value = " << m_RadioTx << " \n";
		holdIn( active, Time::Zero );
 	}

	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &HF_TransceiverType::internalFunction( const InternalMessage & )
{

	if( Rx == myState || Tx == myState || Relay == myState)
		myState = Idle;

	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &HF_TransceiverType::outputFunction( const InternalMessage &msg )
{
	//Relay over to the CCU for audio through the headsets on the Audio_Out port

	if( Rx == myState )
	{
		sendOutput(msg.time(), ANVDT_Out, m_RadioTx);
		//cout << "Received transmission sending to ANVDT for decryption \n";
	}
	if( Tx == myState )
	{
		sendOutput(msg.time(), ANVDT_Out, m_RadioTx);
		//cout << "Transmitting  sending to ANVDT for encryption \n";
	}

	if( Relay == myState )
	{
		if( AUDIO == m_RadioTx && DECODED == m_StateOfHf)
		{
			sendOutput( msg.time(), HF_Audio_Out, m_RadioTx);
			//cout << "Decode transmission sending to speaker for ccu  \n";
		}
		else if( AUDIO == m_RadioTx && ENCODED == m_StateOfHf)
		{
			sendOutput( msg.time(), HF_Transmission_Out, m_RadioTx);
			//cout << "Transmitting msg sending to outside port \n";
		}
	}

	return *this;

}

HF_TransceiverType::~HF_TransceiverType()
{
}
