/*****************************************************************************

    File:		Declarations.h

    Purpose:	This file holds the common definition and preprocessor definitions
    			for the CMS software. The definitions are stored as enumerated
				types for portability and uniformity.

    Author:		Captain Colin Timmons

    Comments:	CMS DEVS Simulator
				Version 0.1

    Copyright  2011


******************************************************************************/
#ifndef DECLARATIONS_H
#define DECLARATIONS_H
/*****************************************************************************/

using namespace std;

namespace LedStatus
{
	// The LED state OFF
	const int ON  = 0;

	// The LED state ON
	const int OFF  = 1;

	// The LED state FLASHING
	const int FLASHING  = 2;
};

namespace RadioState
{
	// The Radio state OFF 32
	const int NONOPERATIONAL  = 0x20;

	// The Radio state ON 33
	const int OPERATIONAL  = 0x21;

	// The Radio state having audio 34
	const int AUDIO  = 0x22;

	// The Radio state with no audio 35
	const int NO_AUDIO  = 0x23;

	// The Radio state unsecured 36
	const int UNCRYPTO  = 0x24;

	// The Radio state secured 37
	const int CRYPTO  = 0x25;

	// The Radio state having a transmission 38
	const int TRANSMISSION  = 0x26;

	// The Radio state with decoding secure data 39
	const int DECODED  = 0x27;

	// The Radio state keyed 40
	const int KEYED  = 0x28;

	// The Radio state unkeyed 41
	const int UNKEYED  = 0x29;

	// The Radio state encoded 42
	const int ENCODED  = 0x2A;

	//The radio reception pattern 43
	const int RECEPTION = 0x2B;

	//The radio reception pattern 44
	const int STOP_RECEPTION = 0x2B;

};

namespace RadioSelectionState
{
	// The HF Command button not pressed 48
	const int HF_NOT_PRESSED  = 0x030;

	// The HF Command button single pressed 49
	const int HF_SINGLE_PRESS  = 0x031;

	// The HF Command button double pressed 50
	const int HF_DOUBLE_PRESS  = 0x032;

	// The HF Command button crypto pressed 51
	const int HF_CRYPTO_PRESS  = 0x033;

	// The VUHF Command button not pressed 304
	const int VUHF_NOT_PRESSED  = 0x130;

	// The VUHF Command button single pressed 305
	const int VUHF_SINGLE_PRESS  = 0x131;

	// The VUHF Command button double pressed 306
	const int VUHF_DOUBLE_PRESS  = 0x132;

	// The VUHF Command button crypto pressed 307
	const int VUHF_CRYPTO_PRESS  = 0x133;

	// The VUHF Command button not pressed 560
	const int FM_NOT_PRESSED  = 0x230;

	// The FM Command button single pressed 561
	const int FM_SINGLE_PRESS  = 0x231;

	// The FM Command button double pressed 562
	const int FM_DOUBLE_PRESS  = 0x232;

	// The AM Command button not pressed 816
	const int AM_NOT_PRESSED  = 0x330;

	// The AM Command button single pressed 817
	const int AM_SINGLE_PRESS  = 0x331;

	// The AM Command button double pressed 818
	const int AM_DOUBLE_PRESS  = 0x332;
};

namespace ButtonState
{
	// The Command button not pressed 48
	const int NOT_PRESSED  = 0x30;

	// The Command button single pressed 49
	const int SINGLE_PRESS  = 0x31;

	// The Command button double pressed 50
	const int DOUBLE_PRESS  = 0x32;

	// The Command button double pressed 51
	const int CRYPTO_PRESS  = 0x33;
};

namespace RadioIdentity
{
	// The HF radio used in the upper byte
	const int HF  = 0x00010000;

	// The VUHF radio used in the upper byte
	const int VUHF  = 0x00100000;

	// The AM radio used in the upper byte
	const int AM  = 0x01000000;

	// The FM radio used in the upper byte
	const int FM  = 0x10000000;
};





#endif // End of DECLARATIONS_H
