/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "CSU_Interface_ControllerType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioIdentity;
using namespace ButtonState;
using namespace RadioSelectionState;
using namespace RadioState;

/*******************************************************************
* Function Name: CSU_Interface_ControllerType
* Description: constructor
********************************************************************/
CSU_Interface_ControllerType::CSU_Interface_ControllerType( const string &name )
: Atomic( name ),
  Status_Out(addOutputPort( "Status_Out" )),
  Button_Out(addOutputPort( "Button_Out" )),
  Gui_Out(addOutputPort( "Gui_Out" )),
  User_Input(addInputPort( "User_Input" )),
  Led_Status_In(addInputPort( "Led_Status_In" )),
  Radio_Tx_In(addInputPort( "Radio_Tx_In" )),
  Csu_In(addInputPort( "Csu_In" ))

{
	m_StateOfRadio = UNKEYED;
	m_StateOfCmdButton = -1;
	m_Index = 0;
	m_StateOfLed = 0;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &CSU_Interface_ControllerType::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	// set next transition
 	myState = Idle;
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &CSU_Interface_ControllerType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();
	this->elapsed = msg.time()-lastChange();
 	this->timeLeft = this->sigma - this->elapsed;
	
 	if(Csu_In == msg.port())
 	{
 		//This is the feedback loop for the CSU from a msg reception
 		m_StateOfRadio = msg.value();
 		myState = Keyed;
 		//cout << "CSU Interface - CSU_In  m_StateOfRadio  is = " << m_StateOfRadio << " \n";
 		holdIn( active, Time::Zero );

 	}
 	if( Led_Status_In == msg.port() )
 	{
 		//This is the status indication from the LED
 		m_StateOfLed = msg.value();
 		myState = LedInput;

 		holdIn( active, Time::Zero );

 	}
 	if ( User_Input == msg.port() )
 	{
		//Get the number representing the radio as per Declarations.h
		int value = msg.value();

		m_Index = (value >> 8);
		//cout << "CSU Interface - User_input m_Index  is = " << m_Index << " \n";
		int temp = (m_Index )  << 8;

		//Get the action performed
		int input = 0;
		input = value - temp;
		//cout << "CSU Interface - User_input  input  is = " << input << " \n";

		switch( input )
		{
			case SINGLE_PRESS:
				m_StateOfCmdButton = SINGLE_PRESS;
			break;

			case DOUBLE_PRESS:
				m_StateOfCmdButton = DOUBLE_PRESS;
			break;

			case HF_CRYPTO_PRESS:
				m_StateOfCmdButton = CRYPTO_PRESS;
			break;

			case VUHF_CRYPTO_PRESS:
				m_StateOfCmdButton = CRYPTO_PRESS;
			break;
			default:
				return *this;
		}

		// Mask the ID into the m_StateOfCsu
		if( 0 == m_Index)
			m_StateOfCmdButton |= HF;

		if( 1 == m_Index)
			m_StateOfCmdButton |= VUHF;

		if( 2 == m_Index)
			m_StateOfCmdButton |= FM;

		if( 3 == m_Index)
			m_StateOfCmdButton |= AM;

		//cout << "CSU state m_StateOfCmdButton is after loading upper bytes= " << m_StateOfCmdButton << " \n";
		myState = UserInput;
		holdIn( active, Time::Zero );

 	}

 	if ( Radio_Tx_In == msg.port() )
 	{

 		int value = msg.value();
 		//cout << "CSU Radio_Tx_In was keyed, key is = " << value << " \n";

 		if( KEYED == (short)value )
 			m_StateOfRadio = KEYED;
 		else
 			m_StateOfRadio = UNKEYED;
 		myState = Keyed;

 		holdIn( active, Time::Zero );
 	}
 	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &CSU_Interface_ControllerType::internalFunction( const InternalMessage & )
{
	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );

	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &CSU_Interface_ControllerType::outputFunction( const InternalMessage &msg )
{
	if( Idle == myState)
	{

	}
	else
	{
		if( Keyed == myState )
		{
			sendOutput( msg.time(), Gui_Out, m_StateOfRadio );
			//cout << "CSU sending to Gui_out " << m_StateOfRadio << "\n";

		}

		if( UserInput == myState )
		{
			sendOutput( msg.time(), Button_Out, m_StateOfCmdButton );
			//cout << "CSU sending to Button_Out " << m_StateOfCmdButton << "\n";

		}

		if( LedInput == myState )
		{
			sendOutput( msg.time(),Status_Out, m_StateOfLed );
			//cout << "CSU sending Status_out m_StateOfLed = " << m_StateOfLed << "\n";
		}



	}
	return *this;
}

CSU_Interface_ControllerType::~CSU_Interface_ControllerType()
{
}
