/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "Audio_MultiplexerType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioState;


/*******************************************************************
* Function Name: Audio_MultiplexerType
* Description: constructor
********************************************************************/
Audio_MultiplexerType::Audio_MultiplexerType( const string &name )
: Atomic( name ),
  Audio_Out(addOutputPort( "Audio_Out" )),
  Audio_In(addInputPort( "Audio_In" )),
  HF_Audio_Out(addOutputPort( "HF_Audio_Out" )),
  HF_Audio_In(addInputPort( "HF_Audio_In" )),
  VUHF_Audio_Out(addOutputPort( "VUHF_Audio_Out" )),
  VUHF_Audio_In(addInputPort( "VUHF_Audio_In" )),
  FM_Audio_Out(addOutputPort( "FM_Audio_Out" )),
  FM_Audio_In(addInputPort( "FM_Audio_In" )),
  AM_Audio_Out(addOutputPort( "AM_Audio_Out" )),
  AM_Audio_In(addInputPort( "AM_Audio_In" ))

{
	m_StateOfHf = -1;
	m_StateOfVuhf = -1;
	m_StateOfFm = -1;
	m_StateOfAm = -1;
	m_StateOfAudioIn = -1;
	m_StateOfAudio = -1;
	m_Index = 0;
	m_StateOfMic = 0;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &Audio_MultiplexerType::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	// TODO: add init code here. (setting first state, etc)
 	
 	// set next transition
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &Audio_MultiplexerType::externalFunction( const ExternalMessage &msg )
{
	//[(!) update common variables]	
	this->sigma = nextChange();	
	this->elapsed = msg.time()-lastChange();	
 	this->timeLeft = this->sigma - this->elapsed; 
	
 	m_StateOfAudioIn = 0;


 	//Auditory communications channel all active voice into the speakers and
 	//headsets, relying on the operators to select and manipulate the conversations
 	//through the CSU or by brain power!

 	if( AM_Audio_In == msg.port() )
 	{
 		m_StateOfAm = msg.value();
 		if( KEYED == m_StateOfAm )
 			m_StateOfAudioIn |= 0x10000028;
 		else
 			m_StateOfAudioIn |= 0x10000000;
 		//cout << "Audio_Multiplexer AM Audio In has speaker audio, m_StateOfAudioIn = " << m_StateOfAudioIn << " \n";
 		holdIn( active, Time::Zero );

 	}

 	if( FM_Audio_In == msg.port() )
 	{
 		m_StateOfFm = msg.value();
 		if( KEYED == m_StateOfFm )
 			m_StateOfAudioIn |= 0x01000028;
 		else
 			m_StateOfAudioIn |= 0x01000000;
 		//cout << "Audio_Multiplexer  FM Audio In has speaker audio, m_StateOfAudioIn = " << m_StateOfAudioIn << " \n";
 		holdIn( active, Time::Zero );

 	}

 	if( VUHF_Audio_In == msg.port() )
 	{
		m_StateOfVuhf = msg.value();
		if( KEYED == m_StateOfVuhf )
			m_StateOfAudioIn |= 0x00100028;
		else
			m_StateOfAudioIn |= 0x00100000;
		//cout << "Audio_Multiplexer  VUHF Audio In has speaker audio, m_StateOfAudioIn = " << m_StateOfAudioIn << " \n";
		holdIn( active, Time::Zero );

 	}
 	if( HF_Audio_In == msg.port() )
 	{
 		m_StateOfHf = msg.value();
		if( KEYED == m_StateOfHf )
			m_StateOfAudioIn |= 0x00010028;
		else
			m_StateOfAudioIn |= 0x00010000;

		//cout << "Audio_Multiplexer  HF Audio In has speaker audio, m_StateOfAudioIn = " << m_StateOfAudioIn << " \n";

		holdIn( active, Time::Zero );

 	}
 	if( Audio_In == msg.port() )
 	{
		//Determine which radio it is to be outputted on by masking it against
		//the  encoded radio as declared in the upper byte as per the
		//Declarations.h file.
		m_Index = msg.value();
		//cout << "Audio_Multiplexer has speaker audio, nValue = " << m_Index << " \n";

		//Because the audio multiplexer does not know the state of the radio the default is HF

		//The data set has whether an activate transmitter is selected
		//Otherwise you can key and talk all you want but you need a
		//transmitter active not just selected.
		if(m_Index & 0x100 && 65536 < m_Index )
			m_StateOfAudio = AUDIO;
		else m_StateOfAudio = NO_AUDIO;

		//Hot mic keyed transmitter
		if(m_Index & 0x1 && 65536 < m_Index )
			m_StateOfMic = KEYED;
		else m_StateOfMic = UNKEYED;

		//cout << "Audio_Multiplexer  , m_StateOfAudio = " << m_StateOfAudio << " \n";
		//Now we have the index for the radio and a flag for audio transmission
		holdIn( active, Time::Zero );
 	}

	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &Audio_MultiplexerType::internalFunction( const InternalMessage & )
{

	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &Audio_MultiplexerType::outputFunction( const InternalMessage &msg )
{
	//Transmission mode
	if( KEYED == m_StateOfMic)
	{
		if( 0x11110000 & m_Index )
		{
			sendOutput( msg.time(),HF_Audio_Out, m_StateOfAudio );
			sendOutput( msg.time(),VUHF_Audio_Out, m_StateOfAudio );
			sendOutput( msg.time(),FM_Audio_Out, m_StateOfAudio );
			sendOutput( msg.time(),AM_Audio_Out, m_StateOfAudio );
		}
		else
		{
				if( 0x00010000 & m_Index )
			{
				sendOutput( msg.time(), HF_Audio_Out, m_StateOfAudio );
				//cout << "Audio_Multiplexer received data for HF, m_StateOfAudio = " << m_StateOfAudio << " \n";
			}
			if( 0x00100000 & m_Index )
			{
				sendOutput( msg.time(),VUHF_Audio_Out, m_StateOfAudio );
				//cout << "Audio_Multiplexer received data for VUHF, m_StateOfAudio = " << m_StateOfAudio << " \n";
			}
			if(  0x01000000 & m_Index)
			{
				sendOutput( msg.time(), FM_Audio_Out, m_StateOfAudio );
				//cout << "Audio_Multiplexer received data for FM, m_StateOfAudio = " << m_StateOfAudio << " \n";
			}
			if( 0x10000000 & m_Index )
			{
				sendOutput( msg.time(), AM_Audio_Out, m_StateOfAudio );
				//cout << "Audio_Multiplexer received data for AM, m_StateOfAudio = " << m_StateOfAudio << " \n";
			}
		}
		m_StateOfAudio = 0;

	}

	//Now produce a valid audio output for the speaker and the final output
	if( 65536 < m_StateOfAudioIn)
	{
		//cout << "sending received audio out to interface for speaker m_StateOfAudioIn = " << m_StateOfAudioIn << "\n";
		sendOutput( msg.time(), Audio_Out, m_StateOfAudioIn );
		//reset the audio
		m_StateOfAudioIn = 0;
	}

	return *this;

}

Audio_MultiplexerType::~Audio_MultiplexerType()
{

}
