/********************************************************************
*																	*
*      				 Auto Generated File                            *
*                     												*		
*********************************************************************/

/** include files **/
#include "ANVDTType.h"           // base header
#include "message.h"       // InternalMessage ....
#include "distri.h"        // class Distribution
#include "mainsimu.h"      // class MainSimulator
#include "Declarations.h"
using namespace RadioState;


/*******************************************************************
* Function Name: ANVDTType
* Description: constructor
********************************************************************/
ANVDTType::ANVDTType( const string &name )
: Atomic( name ),
  HF_Transceiver_Out(addOutputPort( "HF_Transceiver_Out" )),
  HF_Transceiver_In(addInputPort( "HF_Transceiver_In" )),
  HF_Status_Out(addOutputPort( "HF_Status_Out" )),
  HF_Status_In(addInputPort( "HF_Status_In" ))

// TODO: add ports here if needed (Remember to add them to the .h file also). Each in a new line.

{
	m_StateOfHf  = 0;
	fRandNumber = 0.0;
}

/*******************************************************************
* Function Name: initFunction
********************************************************************/
Model &ANVDTType::initFunction()
{
	// [(!) Initialize common variables]
	this->elapsed = Time::Zero;
 	this->timeLeft = Time::Inf;
 	// this->sigma = Time::Inf; // stays in active state until an external event occurs;
 	this->sigma = Time::Zero; // force an internal transition in t=0;

 	// set next transition
 	holdIn( active, this->sigma  ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: This method executes when an external event is received.
********************************************************************/
Model &ANVDTType::externalFunction( const ExternalMessage &msg )
{
	if( HF_Status_In == msg.port() )
 	{
 		//cout << "ANVDT received status request " << msg.value() << " \n";
 		if( 0 ==  msg.value() )
 		{
			//Figure out if the HF is good so check by setting it as a random
			//number distribution where 0 to 0.75 is good
			fRandNumber = rand()/(float)RAND_MAX;
			if( 0.25 < fRandNumber )
				m_StateOfHf = OPERATIONAL;
			else
				m_StateOfHf = NONOPERATIONAL;

 			//Testing remove comment
 			//m_StateOfHf = OPERATIONAL;
			//cout << "ANVDT is " << m_StateOfHf << " \n";

		}
 		holdIn( active, Time::Zero );
 	}

 	if( HF_Transceiver_In == msg.port() )
	{
 		if( DECODED ==  msg.value() )
		{
 			//cout << "ANVDT is decoding incoming" << msg.value() << " \n";
			//HF transmission so encrypt/decrypt if online
			if( NONOPERATIONAL == m_StateOfHf )
				m_StateOfHf = NO_AUDIO;
			else if( OPERATIONAL == m_StateOfHf)
				m_StateOfHf = DECODED;


		}
 		else if( ENCODED ==  msg.value() )
		{
 			//cout << "ANVDT is encoding incoming" << msg.value() << " \n";
			//HF transmission so encrypt/decrypt if online
			if( NONOPERATIONAL == m_StateOfHf )
				m_StateOfHf = NO_AUDIO;
			else if( OPERATIONAL == m_StateOfHf)
				m_StateOfHf = ENCODED;

		}

 		holdIn( active, Time::Zero );
	}
	

	return *this ;
}

/*******************************************************************
* Function Name: internalFunction
* Description: This method executes when the TA has expired, right after the outputFunction has finished.
* 			   The new state and TA should be set.
********************************************************************/
Model &ANVDTType::internalFunction( const InternalMessage & )
{

	this->sigma = Time::Inf; // stays in passive state until an external event occurs;
	holdIn( passive, this->sigma  );
	return *this;

}

/*******************************************************************
* Function Name: outputFunction
* Description: This method executes when the TA has expired. After this method the internalFunction is called.
*              Output values can be send through output ports
********************************************************************/
Model &ANVDTType::outputFunction( const InternalMessage &msg )
{

	if( DECODED  == m_StateOfHf || ENCODED == m_StateOfHf )
	{
				sendOutput( msg.time(), HF_Transceiver_Out, m_StateOfHf);
				//cout << "ANVDT sending to HF Transceiver \n";
	}

	 if( OPERATIONAL == m_StateOfHf )
	 {
		 sendOutput( msg.time(), HF_Status_Out, m_StateOfHf);
		 //cout << "ANVDT sending to to status controller \n";
	 }

	return *this;
}

ANVDTType::~ANVDTType()
{
}
