/*******************************************************************
*
*  DESCRIPTION: Atomic Model ServiceCar
*
*  AUTHOR: Dongchao Chen
*
*  EMAIL: dchen053@uottawa.ca
*
*  DATE: 18/10/2014
*
*******************************************************************/
#ifndef __SERVICECAR_H
#define __SERVICECAR_H

#include <list>
#include "atomic.h"     // class Atomic

class ServiceCar : public Atomic
{
public:
	ServiceCar( const string &name = "ServiceCar" );  //Default constructor for ServiceCar

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
   const Port &service_continue ;
   Port &progress ;
   Time preparationTime;
   Time timeLeft;

};	// class ServiceCar

// ** inline ** // 
inline
string ServiceCar::className() const
{
	return "ServiceCar" ;
}

#endif   //__SERVICECAR_H
