/*******************************************************************
*
*  DESCRIPTION: Atomic Model ServiceCar
*
*  AUTHOR: Dongchao Chen
*
*  EMAIL: dchen053@uottawa.ca
*
*  DATE: 18/10/2014
*
*******************************************************************/
/** include files **/
#include "servicecar.h"      // class ServiceCar
#include "message.h"         // class ExternalMessage, InternalMessage
#include "mainsimu.h"        // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: ServiceCar
* Description: 
********************************************************************/
ServiceCar::ServiceCar( const string &name )
: Atomic( name )
, service_continue( addInputPort( "service_continue" ) )
, progress( addOutputPort( "progress" ) )
, preparationTime( 0, 0, 10, 0 )
{
   string time( MainSimulator::Instance().getParameter( description(), "preparationTime" ) ) ;

   if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description: Resets the list
* Precondition: The time of the next internal event is infinite
********************************************************************/
Model &ServiceCar::initFunction()
{
   passivate();
   return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &ServiceCar::externalFunction( const ExternalMessage &msg )
{
   if(state() == active){
      cout << lastChange()                          << "serviceCar x i'm already servicing - can't do     : " << msg.value() << "\n"  ;
   } else {
         holdIn(active, preparationTime ); 
         cout << lastChange()                       << "serviceCar x ok i'm servicing now                 : " << msg.value() << "\n"  ;
   }
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &ServiceCar::internalFunction( const InternalMessage & )
{

   //cout << "passivate"  ;
   cout << lastChange()                              << "serviceCar i internal transition               : \n"  ;
   passivate();
   return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &ServiceCar::outputFunction( const InternalMessage &msg )
{
   //cout << "output finished" << servicecount ;
   cout << lastChange()                              << "serviceCar o output reporting progress         : \n"  ;
   sendOutput( msg.time(), progress, 1 ) ;
   return *this ;
}
