/*******************************************************************
*
*  DESCRIPTION: Atomic Model CheckCar
*
*  AUTHOR: Dongchao Chen
*
*  EMAIL: dchen053@uottawa.ca
*
*  DATE: 18/10/2014
*
*******************************************************************/
#ifndef __CHECKCAR_H
#define __CHECKCAR_H

#include <list>
#include "atomic.h"     // class Atomic

class CheckCar: public Atomic
{
public:
	CheckCar( const string &name = "CheckCar" );  //Default constructor for CheckCar

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
   const Port &customer_car ;
   const Port &progress ;
   Port &service_continue ;
   Port &finished ;
   Time preparationTime;
   int servicecount, servicemax, newservicemax;
   Time timeLeft;

};	// class CheckCar

// ** inline ** // 
inline
string CheckCar::className() const
{
	return "CheckCar" ;
}

#endif   //__CHECKCAR_H
