/*******************************************************************
*
*  DESCRIPTION: Atomic Model CheckCar
*
*  AUTHOR: Dongchao Chen
*
*  EMAIL: dchen053@uottawa.ca
*
*  DATE: 18/10/2014
*
*******************************************************************/
/** include files **/
#include "checkcar.h"   // class CheckCar
#include "message.h"    // class ExternalMessage, InternalMessage
#include "mainsimu.h"   // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: CheckCar
* Description: 
********************************************************************/
CheckCar::CheckCar( const string &name )
: Atomic( name )
, customer_car( addInputPort( "customer_car" ) )
, progress( addInputPort( "progress" ) )
, service_continue( addOutputPort( "service_continue" ) )
, finished( addOutputPort( "finished" ) )
, preparationTime( 0, 0, 10, 0 )
{
   string time( MainSimulator::Instance().getParameter( description(), "preparationTime" ) ) ;

   if( time != "" )
		preparationTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description: Resets the list
* Precondition: The time of the next internal event is infinite
********************************************************************/
Model &CheckCar::initFunction()
{
   servicecount = 0 ;
   servicemax = 0 ;
   passivate();
   return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &CheckCar::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == progress ){
     if(!servicemax){
        cout << lastChange()                         << "checkCar x no customer_car here for car service         : " << servicecount << ":" <<  servicemax << "\n"  ;
     }
	  else { 
       if (!servicecount) {
            cout << lastChange()                     << "checkCar x no car to service                   : " << servicecount << ":" <<  servicemax << "\n"  ;
       } else {
          ++servicecount ;
          holdIn(active, preparationTime ); 
          cout << lastChange()                       << "checkCar x inc count and issue service_continue  : " << servicecount << ":" <<  servicemax << "\n"  ;
       }
     } 
   } else{
       if(state() == active){
          cout << lastChange()                       << "checkCar x busy and interrupted no new customer_car : " << servicecount << ":" <<  servicemax << "\n"  ;
       }else{
	      if( msg.port() == customer_car ){
           if(!servicecount) {
              cout << lastChange()                   << "checkCar x normal receive new customer_car      : " << servicecount << ":" <<  servicemax << "\n"  ;
             servicecount++ ;
             newservicemax = abs((int)msg.value())    ;
             holdIn(active, preparationTime ) ; 
           } else {
                cout << lastChange()                 << "checkCar x customer_car rejected - busy with customer_car   : " << servicecount << ":" <<  servicemax << "\n"  ;
           }
         }
      }
   }
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &CheckCar::internalFunction( const InternalMessage & )
{

    cout << lastChange()                              << "checkCar i transition :                     : " << servicecount << ":" <<  servicemax << "\n"  ;
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &CheckCar::outputFunction( const InternalMessage &msg )
{
  if(servicecount == 1) {
      servicemax = newservicemax ;
        cout << lastChange()                         << "checkCar o first service_continue ->servicecar     : " << servicecount << ":" <<  servicemax << "\n"  ;
      sendOutput( msg.time(), service_continue, servicecount ) ;
   } else { 
      if(servicecount > servicemax){
            cout << lastChange()                     << "checkCar o output finished - car service done   : " << servicecount << ":" <<  servicemax << "\n"  ;
          servicecount=0;
          sendOutput( msg.time(), finished, servicemax  ) ;
          servicemax=newservicemax ;
      } else {
           cout << lastChange()                      << "checkCar o output ongoing service_continue       : " << servicecount << ":" <<  servicemax << "\n"  ;
         sendOutput( msg.time(), service_continue, servicecount ) ;
      }
   }
	return *this ;
}
