/*******************************************************************
*
*  DESCRIPTION: Atomic Model Reception
*
*  AUTHOR: Dongchao Chen
*
*  EMAIL: dchen053@uottawa.ca
*
*  DATE: 18/10/2014
*
*******************************************************************/
#ifndef __RECEPTION_H
#define __RECEPTION_H

#include <list>
#include "atomic.h"     // class Atomic

class Reception : public Atomic
{
public:
	Reception( const string &name = "Reception" );    //Default constructor for Reception

	virtual string className() const ;

protected:
	Model &initFunction();
	Model &externalFunction( const ExternalMessage & );
	Model &internalFunction( const InternalMessage & );
	Model &outputFunction( const InternalMessage & );

private:
	const Port &new_customer;
	const Port &next;
	Port &customer_car;
	Time preparationTime;
    Time openingTime ;
    Time closingTime ;
    unsigned int numberofServiceAreas  ;
    string initInt ;
    bool we_are_full ;
    bool cust_car_is_ready ;
	typedef list<Value> ElementList ;
	ElementList elements ;

	Time timeLeft;

};	// class Reception

// ** inline ** // 
inline
string Reception::className() const
{
	return "Reception" ;
}

#endif   //__RECEPTION_H
