/*******************************************************************
*
*  DESCRIPTION: Atomic Model Reception
*
*  AUTHOR: Dongchao Chen
*
*  EMAIL: dchen053@uottawa.ca
*
*  DATE: 18/10/2014
*
*******************************************************************/
/** include files **/
#include "reception.h"      // class Reception
#include "message.h"        // class ExternalMessage, InternalMessage
#include "mainsimu.h"       // MainSimulator::Instance().getParameter( ... )

/** public functions **/

/*******************************************************************
* Function Name: Reception
* Description: 
********************************************************************/
Reception::Reception( const string &name )
: Atomic( name )
, new_customer( addInputPort( "new_customer" ) )
, next( addInputPort( "next" ) )
, customer_car( addOutputPort( "customer_car" ) )
, preparationTime( 0,0, 0, 0 )
, openingTime( 9,0, 0, 0 )
, closingTime( 16,0, 0, 0 )
, numberofServiceAreas( 7 )
{
    initInt = ( MainSimulator::Instance().getParameter( description(), "numberofServiceAreas" ) ) ;
	if(initInt != "")
		numberofServiceAreas = str2Int(initInt) ;
	string time = ( MainSimulator::Instance().getParameter( description(), "preparationTime" ) ) ;
	if( time != "" )
		preparationTime = time ;
	time = ( MainSimulator::Instance().getParameter( description(), "openingTime" ) ) ;
	if( time != "" )
		openingTime = time ;
	time = ( MainSimulator::Instance().getParameter( description(), "closingTime" ) ) ;
	if( time != "" )
		closingTime = time ;
}

/*******************************************************************
* Function Name: initFunction
* Description: Resets the list
* Precondition: The time of the next internal event is infinite
********************************************************************/
Model &Reception::initFunction()
{
    we_are_full = false ;
    cust_car_is_ready = false ;
	elements.erase( elements.begin(), elements.end() ) ;
	return *this ;
}

/*******************************************************************
* Function Name: externalFunction
* Description: 
********************************************************************/
Model &Reception::externalFunction( const ExternalMessage &msg )
{
	if( msg.port() == new_customer ){
      if    (   (msg.time().asMsecs() - Time(openingTime).asMsecs() < 0)
             || (msg.time().asMsecs() - Time(closingTime).asMsecs() > 0)
           ) { 
          cout << lastChange()        << "reception  x we are closed - sorry            : " << elements.size() << " : " << elements.front() << "\n" ;
      } else {  
          if (!(elements.size() < numberofServiceAreas)) {
              cout << lastChange()    << "reception  x we are full - sorry              : " << elements.size() << " : " << elements.front() <<  "\n" ;
          }else{
            elements.push_back( abs((int)msg.value()) ) ;
             cout << lastChange()     << "reception  x queued a new customer_car request         : " << elements.size() << " : " << elements.front() << "\n" ;
            if (elements.size() == 1) {
                cout << lastChange()  << "reception  x activating first customer_car is coming  : " << elements.size() << " : " << elements.front() << "\n" ;
               holdIn( active, preparationTime ) ;
            } else {
                cout << lastChange()  << "reception  x NEW customer_car in queue                : " << elements.size() << " : " << elements.front() << "\n" ;
            }
         }
      }
   } 
   if (msg.port() == next) {
            cout << lastChange()      << "reception  x activating queued customer_car is coming : " << elements.size() << " : " << elements.front() << "\n" ;
            holdIn( active, preparationTime ) ;
	}
	return *this;
}

/*******************************************************************
* Function Name: internalFunction
* Description: 
********************************************************************/
Model &Reception::internalFunction( const InternalMessage & )
{
    cout << lastChange()              << "reception  i transition                       : " << elements.size() << " : " << elements.front() << "\n" ;
	passivate();
	return *this ;
}

/*******************************************************************
* Function Name: outputFunction
* Description: 
********************************************************************/
Model &Reception::outputFunction( const InternalMessage &msg )
{  
   if (elements.size()) {
      cout << lastChange()            << "reception  o transition                       : " << elements.size() << " : " << elements.front() << "\n" ;
     sendOutput( msg.time(), customer_car, elements.front() ) ;
     elements.pop_front();
   } else {
      cout << lastChange()            << "reception  o transition no customer to work on: " << elements.size() << " : " << elements.front() << "\n" ;
   }
	return *this ;
}
